package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{TimestampFormat, Format}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TimeSeriesReplacementsDataSource(
    s3Config: zio.aws.forecast.model.S3Config,
    schema: zio.aws.forecast.model.Schema,
    format: Optional[Format] = Optional.Absent,
    timestampFormat: Optional[TimestampFormat] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.TimeSeriesReplacementsDataSource = {
    import TimeSeriesReplacementsDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.TimeSeriesReplacementsDataSource
      .builder()
      .s3Config(s3Config.buildAwsValue())
      .schema(schema.buildAwsValue())
      .optionallyWith(
        format.map(value => Format.unwrap(value): java.lang.String)
      )(_.format)
      .optionallyWith(
        timestampFormat.map(value =>
          TimestampFormat.unwrap(value): java.lang.String
        )
      )(_.timestampFormat)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.TimeSeriesReplacementsDataSource.ReadOnly =
    zio.aws.forecast.model.TimeSeriesReplacementsDataSource
      .wrap(buildAwsValue())
}
object TimeSeriesReplacementsDataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.TimeSeriesReplacementsDataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.TimeSeriesReplacementsDataSource =
      zio.aws.forecast.model.TimeSeriesReplacementsDataSource(
        s3Config.asEditable,
        schema.asEditable,
        format.map(value => value),
        timestampFormat.map(value => value)
      )
    def s3Config: zio.aws.forecast.model.S3Config.ReadOnly
    def schema: zio.aws.forecast.model.Schema.ReadOnly
    def format: Optional[Format]
    def timestampFormat: Optional[TimestampFormat]
    def getS3Config
        : ZIO[Any, Nothing, zio.aws.forecast.model.S3Config.ReadOnly] =
      ZIO.succeed(s3Config)
    def getSchema: ZIO[Any, Nothing, zio.aws.forecast.model.Schema.ReadOnly] =
      ZIO.succeed(schema)
    def getFormat: ZIO[Any, AwsError, Format] =
      AwsError.unwrapOptionField("format", format)
    def getTimestampFormat: ZIO[Any, AwsError, TimestampFormat] =
      AwsError.unwrapOptionField("timestampFormat", timestampFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.TimeSeriesReplacementsDataSource
  ) extends zio.aws.forecast.model.TimeSeriesReplacementsDataSource.ReadOnly {
    override val s3Config: zio.aws.forecast.model.S3Config.ReadOnly =
      zio.aws.forecast.model.S3Config.wrap(impl.s3Config())
    override val schema: zio.aws.forecast.model.Schema.ReadOnly =
      zio.aws.forecast.model.Schema.wrap(impl.schema())
    override val format: Optional[Format] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value => zio.aws.forecast.model.primitives.Format(value))
    override val timestampFormat: Optional[TimestampFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timestampFormat())
        .map(value => zio.aws.forecast.model.primitives.TimestampFormat(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.TimeSeriesReplacementsDataSource
  ): zio.aws.forecast.model.TimeSeriesReplacementsDataSource.ReadOnly =
    new Wrapper(impl)
}
