package zio.aws.forecast.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WeightedQuantileLoss(
    quantile: Optional[Double] = Optional.Absent,
    lossValue: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.WeightedQuantileLoss = {
    import WeightedQuantileLoss.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.WeightedQuantileLoss
      .builder()
      .optionallyWith(quantile.map(value => value: java.lang.Double))(
        _.quantile
      )
      .optionallyWith(lossValue.map(value => value: java.lang.Double))(
        _.lossValue
      )
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.WeightedQuantileLoss.ReadOnly =
    zio.aws.forecast.model.WeightedQuantileLoss.wrap(buildAwsValue())
}
object WeightedQuantileLoss {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.WeightedQuantileLoss
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.WeightedQuantileLoss =
      zio.aws.forecast.model.WeightedQuantileLoss(
        quantile.map(value => value),
        lossValue.map(value => value)
      )
    def quantile: Optional[Double]
    def lossValue: Optional[Double]
    def getQuantile: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("quantile", quantile)
    def getLossValue: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("lossValue", lossValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.WeightedQuantileLoss
  ) extends zio.aws.forecast.model.WeightedQuantileLoss.ReadOnly {
    override val quantile: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.quantile())
      .map(value => value: Double)
    override val lossValue: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.lossValue())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.WeightedQuantileLoss
  ): zio.aws.forecast.model.WeightedQuantileLoss.ReadOnly = new Wrapper(impl)
}
