package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  Status,
  LongArn,
  ErrorMessage,
  Timestamp,
  Name
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class WhatIfForecastExportSummary(
    whatIfForecastExportArn: Optional[LongArn] = Optional.Absent,
    whatIfForecastArns: Optional[Iterable[LongArn]] = Optional.Absent,
    whatIfForecastExportName: Optional[Name] = Optional.Absent,
    destination: Optional[zio.aws.forecast.model.DataDestination] =
      Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.WhatIfForecastExportSummary = {
    import WhatIfForecastExportSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.WhatIfForecastExportSummary
      .builder()
      .optionallyWith(
        whatIfForecastExportArn.map(value =>
          LongArn.unwrap(value): java.lang.String
        )
      )(_.whatIfForecastExportArn)
      .optionallyWith(
        whatIfForecastArns.map(value =>
          value.map { item =>
            LongArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.whatIfForecastArns)
      .optionallyWith(
        whatIfForecastExportName.map(value =>
          Name.unwrap(value): java.lang.String
        )
      )(_.whatIfForecastExportName)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.WhatIfForecastExportSummary.ReadOnly =
    zio.aws.forecast.model.WhatIfForecastExportSummary.wrap(buildAwsValue())
}
object WhatIfForecastExportSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.WhatIfForecastExportSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.WhatIfForecastExportSummary =
      zio.aws.forecast.model.WhatIfForecastExportSummary(
        whatIfForecastExportArn.map(value => value),
        whatIfForecastArns.map(value => value),
        whatIfForecastExportName.map(value => value),
        destination.map(value => value.asEditable),
        status.map(value => value),
        message.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def whatIfForecastExportArn: Optional[LongArn]
    def whatIfForecastArns: Optional[List[LongArn]]
    def whatIfForecastExportName: Optional[Name]
    def destination: Optional[zio.aws.forecast.model.DataDestination.ReadOnly]
    def status: Optional[Status]
    def message: Optional[ErrorMessage]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getWhatIfForecastExportArn: ZIO[Any, AwsError, LongArn] = AwsError
      .unwrapOptionField("whatIfForecastExportArn", whatIfForecastExportArn)
    def getWhatIfForecastArns: ZIO[Any, AwsError, List[LongArn]] =
      AwsError.unwrapOptionField("whatIfForecastArns", whatIfForecastArns)
    def getWhatIfForecastExportName: ZIO[Any, AwsError, Name] = AwsError
      .unwrapOptionField("whatIfForecastExportName", whatIfForecastExportName)
    def getDestination
        : ZIO[Any, AwsError, zio.aws.forecast.model.DataDestination.ReadOnly] =
      AwsError.unwrapOptionField("destination", destination)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.WhatIfForecastExportSummary
  ) extends zio.aws.forecast.model.WhatIfForecastExportSummary.ReadOnly {
    override val whatIfForecastExportArn: Optional[LongArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.whatIfForecastExportArn())
        .map(value => zio.aws.forecast.model.primitives.LongArn(value))
    override val whatIfForecastArns: Optional[List[LongArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.whatIfForecastArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.primitives.LongArn(item)
          }.toList
        )
    override val whatIfForecastExportName: Optional[Name] =
      zio.aws.core.internal
        .optionalFromNullable(impl.whatIfForecastExportName())
        .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val destination
        : Optional[zio.aws.forecast.model.DataDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.forecast.model.DataDestination.wrap(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.ErrorMessage(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.WhatIfForecastExportSummary
  ): zio.aws.forecast.model.WhatIfForecastExportSummary.ReadOnly = new Wrapper(
    impl
  )
}
