package zio.aws.honeycode.model
import zio.aws.honeycode.model.primitives.{
  PaginationToken,
  MaxResults,
  RowId,
  ResourceId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTableRowsRequest(
    workbookId: ResourceId,
    tableId: ResourceId,
    rowIds: Optional[Iterable[RowId]] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.ListTableRowsRequest = {
    import ListTableRowsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.ListTableRowsRequest
      .builder()
      .workbookId(ResourceId.unwrap(workbookId): java.lang.String)
      .tableId(ResourceId.unwrap(tableId): java.lang.String)
      .optionallyWith(
        rowIds.map(value =>
          value.map { item =>
            RowId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.rowIds)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.ListTableRowsRequest.ReadOnly =
    zio.aws.honeycode.model.ListTableRowsRequest.wrap(buildAwsValue())
}
object ListTableRowsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.ListTableRowsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.ListTableRowsRequest =
      zio.aws.honeycode.model.ListTableRowsRequest(
        workbookId,
        tableId,
        rowIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def workbookId: ResourceId
    def tableId: ResourceId
    def rowIds: Optional[List[RowId]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def getWorkbookId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(workbookId)
    def getTableId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(tableId)
    def getRowIds: ZIO[Any, AwsError, List[RowId]] =
      AwsError.unwrapOptionField("rowIds", rowIds)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.ListTableRowsRequest
  ) extends zio.aws.honeycode.model.ListTableRowsRequest.ReadOnly {
    override val workbookId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.workbookId())
    override val tableId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.tableId())
    override val rowIds: Optional[List[RowId]] = zio.aws.core.internal
      .optionalFromNullable(impl.rowIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.honeycode.model.primitives.RowId(item)
        }.toList
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.honeycode.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.honeycode.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.ListTableRowsRequest
  ): zio.aws.honeycode.model.ListTableRowsRequest.ReadOnly = new Wrapper(impl)
}
