package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.honeycode.model.primitives.JobId
import scala.jdk.CollectionConverters._
final case class StartTableDataImportJobResponse(
    jobId: JobId,
    jobStatus: zio.aws.honeycode.model.TableDataImportJobStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.StartTableDataImportJobResponse = {
    import StartTableDataImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.StartTableDataImportJobResponse
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .jobStatus(jobStatus.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.honeycode.model.StartTableDataImportJobResponse.ReadOnly =
    zio.aws.honeycode.model.StartTableDataImportJobResponse
      .wrap(buildAwsValue())
}
object StartTableDataImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.StartTableDataImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.StartTableDataImportJobResponse =
      zio.aws.honeycode.model.StartTableDataImportJobResponse(jobId, jobStatus)
    def jobId: JobId
    def jobStatus: zio.aws.honeycode.model.TableDataImportJobStatus
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getJobStatus
        : ZIO[Any, Nothing, zio.aws.honeycode.model.TableDataImportJobStatus] =
      ZIO.succeed(jobStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.StartTableDataImportJobResponse
  ) extends zio.aws.honeycode.model.StartTableDataImportJobResponse.ReadOnly {
    override val jobId: JobId =
      zio.aws.honeycode.model.primitives.JobId(impl.jobId())
    override val jobStatus: zio.aws.honeycode.model.TableDataImportJobStatus =
      zio.aws.honeycode.model.TableDataImportJobStatus.wrap(impl.jobStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.StartTableDataImportJobResponse
  ): zio.aws.honeycode.model.StartTableDataImportJobResponse.ReadOnly =
    new Wrapper(impl)
}
