package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.TimeOfDay
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddOn(
    name: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    snapshotTimeOfDay: Optional[TimeOfDay] = Optional.Absent,
    nextSnapshotTimeOfDay: Optional[TimeOfDay] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.AddOn = {
    import AddOn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AddOn
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        snapshotTimeOfDay.map(value =>
          TimeOfDay.unwrap(value): java.lang.String
        )
      )(_.snapshotTimeOfDay)
      .optionallyWith(
        nextSnapshotTimeOfDay.map(value =>
          TimeOfDay.unwrap(value): java.lang.String
        )
      )(_.nextSnapshotTimeOfDay)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.AddOn.ReadOnly =
    zio.aws.lightsail.model.AddOn.wrap(buildAwsValue())
}
object AddOn {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.AddOn] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.AddOn =
      zio.aws.lightsail.model.AddOn(
        name.map(value => value),
        status.map(value => value),
        snapshotTimeOfDay.map(value => value),
        nextSnapshotTimeOfDay.map(value => value)
      )
    def name: Optional[String]
    def status: Optional[String]
    def snapshotTimeOfDay: Optional[TimeOfDay]
    def nextSnapshotTimeOfDay: Optional[TimeOfDay]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getSnapshotTimeOfDay: ZIO[Any, AwsError, TimeOfDay] =
      AwsError.unwrapOptionField("snapshotTimeOfDay", snapshotTimeOfDay)
    def getNextSnapshotTimeOfDay: ZIO[Any, AwsError, TimeOfDay] =
      AwsError.unwrapOptionField("nextSnapshotTimeOfDay", nextSnapshotTimeOfDay)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AddOn
  ) extends zio.aws.lightsail.model.AddOn.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val snapshotTimeOfDay: Optional[TimeOfDay] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotTimeOfDay())
      .map(value => zio.aws.lightsail.model.primitives.TimeOfDay(value))
    override val nextSnapshotTimeOfDay: Optional[TimeOfDay] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextSnapshotTimeOfDay())
        .map(value => zio.aws.lightsail.model.primitives.TimeOfDay(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AddOn
  ): zio.aws.lightsail.model.AddOn.ReadOnly = new Wrapper(impl)
}
