package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.IsoDate
import scala.jdk.CollectionConverters._
final case class AutoSnapshotDetails(
    date: Optional[String] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    status: Optional[zio.aws.lightsail.model.AutoSnapshotStatus] =
      Optional.Absent,
    fromAttachedDisks: Optional[
      Iterable[zio.aws.lightsail.model.AttachedDisk]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails = {
    import AutoSnapshotDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails
      .builder()
      .optionallyWith(date.map(value => value: java.lang.String))(_.date)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        fromAttachedDisks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fromAttachedDisks)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.AutoSnapshotDetails.ReadOnly =
    zio.aws.lightsail.model.AutoSnapshotDetails.wrap(buildAwsValue())
}
object AutoSnapshotDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.AutoSnapshotDetails =
      zio.aws.lightsail.model.AutoSnapshotDetails(
        date.map(value => value),
        createdAt.map(value => value),
        status.map(value => value),
        fromAttachedDisks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def date: Optional[String]
    def createdAt: Optional[IsoDate]
    def status: Optional[zio.aws.lightsail.model.AutoSnapshotStatus]
    def fromAttachedDisks
        : Optional[List[zio.aws.lightsail.model.AttachedDisk.ReadOnly]]
    def getDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("date", date)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lightsail.model.AutoSnapshotStatus] =
      AwsError.unwrapOptionField("status", status)
    def getFromAttachedDisks: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.AttachedDisk.ReadOnly
    ]] = AwsError.unwrapOptionField("fromAttachedDisks", fromAttachedDisks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails
  ) extends zio.aws.lightsail.model.AutoSnapshotDetails.ReadOnly {
    override val date: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.date())
      .map(value => value: String)
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val status: Optional[zio.aws.lightsail.model.AutoSnapshotStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.lightsail.model.AutoSnapshotStatus.wrap(value))
    override val fromAttachedDisks
        : Optional[List[zio.aws.lightsail.model.AttachedDisk.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fromAttachedDisks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.AttachedDisk.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails
  ): zio.aws.lightsail.model.AutoSnapshotDetails.ReadOnly = new Wrapper(impl)
}
