package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait BucketMetricName {
  def unwrap: software.amazon.awssdk.services.lightsail.model.BucketMetricName
}
object BucketMetricName {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.BucketMetricName
  ): zio.aws.lightsail.model.BucketMetricName = value match {
    case software.amazon.awssdk.services.lightsail.model.BucketMetricName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.BucketMetricName.BUCKET_SIZE_BYTES =>
      val r = BucketSizeBytes
      r
    case software.amazon.awssdk.services.lightsail.model.BucketMetricName.NUMBER_OF_OBJECTS =>
      val r = NumberOfObjects
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.BucketMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.BucketMetricName =
      software.amazon.awssdk.services.lightsail.model.BucketMetricName.UNKNOWN_TO_SDK_VERSION
  }
  case object BucketSizeBytes extends zio.aws.lightsail.model.BucketMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.BucketMetricName =
      software.amazon.awssdk.services.lightsail.model.BucketMetricName.BUCKET_SIZE_BYTES
  }
  case object NumberOfObjects extends zio.aws.lightsail.model.BucketMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.BucketMetricName =
      software.amazon.awssdk.services.lightsail.model.BucketMetricName.NUMBER_OF_OBJECTS
  }
}
