package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.IsoDate
import scala.jdk.CollectionConverters._
final case class ContainerServiceRegistryLogin(
    username: Optional[String] = Optional.Absent,
    password: Optional[String] = Optional.Absent,
    expiresAt: Optional[IsoDate] = Optional.Absent,
    registry: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin = {
    import ContainerServiceRegistryLogin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin
      .builder()
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(password.map(value => value: java.lang.String))(
        _.password
      )
      .optionallyWith(expiresAt.map(value => IsoDate.unwrap(value): Instant))(
        _.expiresAt
      )
      .optionallyWith(registry.map(value => value: java.lang.String))(
        _.registry
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.ContainerServiceRegistryLogin.ReadOnly =
    zio.aws.lightsail.model.ContainerServiceRegistryLogin.wrap(buildAwsValue())
}
object ContainerServiceRegistryLogin {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContainerServiceRegistryLogin =
      zio.aws.lightsail.model.ContainerServiceRegistryLogin(
        username.map(value => value),
        password.map(value => value),
        expiresAt.map(value => value),
        registry.map(value => value)
      )
    def username: Optional[String]
    def password: Optional[String]
    def expiresAt: Optional[IsoDate]
    def registry: Optional[String]
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("password", password)
    def getExpiresAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("expiresAt", expiresAt)
    def getRegistry: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("registry", registry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin
  ) extends zio.aws.lightsail.model.ContainerServiceRegistryLogin.ReadOnly {
    override val username: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: String)
    override val password: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value => value: String)
    override val expiresAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.expiresAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val registry: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.registry())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin
  ): zio.aws.lightsail.model.ContainerServiceRegistryLogin.ReadOnly =
    new Wrapper(impl)
}
