package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateContainerServiceRegistryLoginResponse(
    registryLogin: Optional[
      zio.aws.lightsail.model.ContainerServiceRegistryLogin
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse = {
    import CreateContainerServiceRegistryLoginResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse
      .builder()
      .optionallyWith(registryLogin.map(value => value.buildAwsValue()))(
        _.registryLogin
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CreateContainerServiceRegistryLoginResponse.ReadOnly =
    zio.aws.lightsail.model.CreateContainerServiceRegistryLoginResponse
      .wrap(buildAwsValue())
}
object CreateContainerServiceRegistryLoginResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.CreateContainerServiceRegistryLoginResponse =
      zio.aws.lightsail.model.CreateContainerServiceRegistryLoginResponse(
        registryLogin.map(value => value.asEditable)
      )
    def registryLogin: Optional[
      zio.aws.lightsail.model.ContainerServiceRegistryLogin.ReadOnly
    ]
    def getRegistryLogin: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceRegistryLogin.ReadOnly
    ] = AwsError.unwrapOptionField("registryLogin", registryLogin)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse
  ) extends zio.aws.lightsail.model.CreateContainerServiceRegistryLoginResponse.ReadOnly {
    override val registryLogin: Optional[
      zio.aws.lightsail.model.ContainerServiceRegistryLogin.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.registryLogin())
      .map(value =>
        zio.aws.lightsail.model.ContainerServiceRegistryLogin.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse
  ): zio.aws.lightsail.model.CreateContainerServiceRegistryLoginResponse.ReadOnly =
    new Wrapper(impl)
}
