package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{DomainName, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLoadBalancerTlsCertificateRequest(
    loadBalancerName: ResourceName,
    certificateName: ResourceName,
    certificateDomainName: DomainName,
    certificateAlternativeNames: Optional[Iterable[DomainName]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest = {
    import CreateLoadBalancerTlsCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest
      .builder()
      .loadBalancerName(ResourceName.unwrap(loadBalancerName): java.lang.String)
      .certificateName(ResourceName.unwrap(certificateName): java.lang.String)
      .certificateDomainName(
        DomainName.unwrap(certificateDomainName): java.lang.String
      )
      .optionallyWith(
        certificateAlternativeNames.map(value =>
          value.map { item =>
            DomainName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.certificateAlternativeNames)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CreateLoadBalancerTlsCertificateRequest.ReadOnly =
    zio.aws.lightsail.model.CreateLoadBalancerTlsCertificateRequest
      .wrap(buildAwsValue())
}
object CreateLoadBalancerTlsCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.CreateLoadBalancerTlsCertificateRequest =
      zio.aws.lightsail.model.CreateLoadBalancerTlsCertificateRequest(
        loadBalancerName,
        certificateName,
        certificateDomainName,
        certificateAlternativeNames.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def loadBalancerName: ResourceName
    def certificateName: ResourceName
    def certificateDomainName: DomainName
    def certificateAlternativeNames: Optional[List[DomainName]]
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def getLoadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerName)
    def getCertificateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(certificateName)
    def getCertificateDomainName: ZIO[Any, Nothing, DomainName] =
      ZIO.succeed(certificateDomainName)
    def getCertificateAlternativeNames: ZIO[Any, AwsError, List[DomainName]] =
      AwsError.unwrapOptionField(
        "certificateAlternativeNames",
        certificateAlternativeNames
      )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest
  ) extends zio.aws.lightsail.model.CreateLoadBalancerTlsCertificateRequest.ReadOnly {
    override val loadBalancerName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.loadBalancerName())
    override val certificateName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.certificateName())
    override val certificateDomainName: DomainName =
      zio.aws.lightsail.model.primitives
        .DomainName(impl.certificateDomainName())
    override val certificateAlternativeNames: Optional[List[DomainName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateAlternativeNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.primitives.DomainName(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest
  ): zio.aws.lightsail.model.CreateLoadBalancerTlsCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
