package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAlarmsRequest(
    alarmName: Optional[ResourceName] = Optional.Absent,
    pageToken: Optional[String] = Optional.Absent,
    monitoredResourceName: Optional[ResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest = {
    import GetAlarmsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest
      .builder()
      .optionallyWith(
        alarmName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.alarmName)
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .optionallyWith(
        monitoredResourceName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.monitoredResourceName)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetAlarmsRequest.ReadOnly =
    zio.aws.lightsail.model.GetAlarmsRequest.wrap(buildAwsValue())
}
object GetAlarmsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetAlarmsRequest =
      zio.aws.lightsail.model.GetAlarmsRequest(
        alarmName.map(value => value),
        pageToken.map(value => value),
        monitoredResourceName.map(value => value)
      )
    def alarmName: Optional[ResourceName]
    def pageToken: Optional[String]
    def monitoredResourceName: Optional[ResourceName]
    def getAlarmName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("alarmName", alarmName)
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getMonitoredResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("monitoredResourceName", monitoredResourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest
  ) extends zio.aws.lightsail.model.GetAlarmsRequest.ReadOnly {
    override val alarmName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.alarmName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val pageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => value: String)
    override val monitoredResourceName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoredResourceName())
        .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest
  ): zio.aws.lightsail.model.GetAlarmsRequest.ReadOnly = new Wrapper(impl)
}
