package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.BucketName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBucketsRequest(
    bucketName: Optional[BucketName] = Optional.Absent,
    pageToken: Optional[String] = Optional.Absent,
    includeConnectedResources: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBucketsRequest = {
    import GetBucketsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketsRequest
      .builder()
      .optionallyWith(
        bucketName.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucketName)
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .optionallyWith(
        includeConnectedResources.map(value => value: java.lang.Boolean)
      )(_.includeConnectedResources)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetBucketsRequest.ReadOnly =
    zio.aws.lightsail.model.GetBucketsRequest.wrap(buildAwsValue())
}
object GetBucketsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBucketsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetBucketsRequest =
      zio.aws.lightsail.model.GetBucketsRequest(
        bucketName.map(value => value),
        pageToken.map(value => value),
        includeConnectedResources.map(value => value)
      )
    def bucketName: Optional[BucketName]
    def pageToken: Optional[String]
    def includeConnectedResources: Optional[Boolean]
    def getBucketName: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getIncludeConnectedResources: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("includeConnectedResources", includeConnectedResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketsRequest
  ) extends zio.aws.lightsail.model.GetBucketsRequest.ReadOnly {
    override val bucketName: Optional[BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketName())
      .map(value => zio.aws.lightsail.model.primitives.BucketName(value))
    override val pageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => value: String)
    override val includeConnectedResources: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeConnectedResources())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketsRequest
  ): zio.aws.lightsail.model.GetBucketsRequest.ReadOnly = new Wrapper(impl)
}
