package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDistributionBundlesResponse(
    bundles: Optional[Iterable[zio.aws.lightsail.model.DistributionBundle]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse = {
    import GetDistributionBundlesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse
      .builder()
      .optionallyWith(
        bundles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bundles)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetDistributionBundlesResponse.ReadOnly =
    zio.aws.lightsail.model.GetDistributionBundlesResponse.wrap(buildAwsValue())
}
object GetDistributionBundlesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetDistributionBundlesResponse =
      zio.aws.lightsail.model.GetDistributionBundlesResponse(
        bundles.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def bundles
        : Optional[List[zio.aws.lightsail.model.DistributionBundle.ReadOnly]]
    def getBundles: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.DistributionBundle.ReadOnly
    ]] = AwsError.unwrapOptionField("bundles", bundles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse
  ) extends zio.aws.lightsail.model.GetDistributionBundlesResponse.ReadOnly {
    override val bundles
        : Optional[List[zio.aws.lightsail.model.DistributionBundle.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bundles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.DistributionBundle.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse
  ): zio.aws.lightsail.model.GetDistributionBundlesResponse.ReadOnly =
    new Wrapper(impl)
}
