package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDistributionsRequest(
    distributionName: Optional[ResourceName] = Optional.Absent,
    pageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest = {
    import GetDistributionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest
      .builder()
      .optionallyWith(
        distributionName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.distributionName)
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetDistributionsRequest.ReadOnly =
    zio.aws.lightsail.model.GetDistributionsRequest.wrap(buildAwsValue())
}
object GetDistributionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetDistributionsRequest =
      zio.aws.lightsail.model.GetDistributionsRequest(
        distributionName.map(value => value),
        pageToken.map(value => value)
      )
    def distributionName: Optional[ResourceName]
    def pageToken: Optional[String]
    def getDistributionName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("distributionName", distributionName)
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest
  ) extends zio.aws.lightsail.model.GetDistributionsRequest.ReadOnly {
    override val distributionName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distributionName())
        .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val pageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest
  ): zio.aws.lightsail.model.GetDistributionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
