package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetLoadBalancerTlsPoliciesRequest(
    pageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsPoliciesRequest = {
    import GetLoadBalancerTlsPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsPoliciesRequest
      .builder()
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetLoadBalancerTlsPoliciesRequest.ReadOnly =
    zio.aws.lightsail.model.GetLoadBalancerTlsPoliciesRequest
      .wrap(buildAwsValue())
}
object GetLoadBalancerTlsPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetLoadBalancerTlsPoliciesRequest =
      zio.aws.lightsail.model
        .GetLoadBalancerTlsPoliciesRequest(pageToken.map(value => value))
    def pageToken: Optional[String]
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsPoliciesRequest
  ) extends zio.aws.lightsail.model.GetLoadBalancerTlsPoliciesRequest.ReadOnly {
    override val pageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsPoliciesRequest
  ): zio.aws.lightsail.model.GetLoadBalancerTlsPoliciesRequest.ReadOnly =
    new Wrapper(impl)
}
