package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRelationalDatabaseBlueprintsResponse(
    blueprints: Optional[
      Iterable[zio.aws.lightsail.model.RelationalDatabaseBlueprint]
    ] = Optional.Absent,
    nextPageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse = {
    import GetRelationalDatabaseBlueprintsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse
      .builder()
      .optionallyWith(
        blueprints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blueprints)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseBlueprintsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsResponse =
      zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsResponse(
        blueprints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def blueprints: Optional[
      List[zio.aws.lightsail.model.RelationalDatabaseBlueprint.ReadOnly]
    ]
    def nextPageToken: Optional[String]
    def getBlueprints: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.RelationalDatabaseBlueprint.ReadOnly
    ]] = AwsError.unwrapOptionField("blueprints", blueprints)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly {
    override val blueprints: Optional[
      List[zio.aws.lightsail.model.RelationalDatabaseBlueprint.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.blueprints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.RelationalDatabaseBlueprint.wrap(item)
        }.toList
      )
    override val nextPageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse
  ): zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly =
    new Wrapper(impl)
}
