package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRelationalDatabaseBundlesRequest(
    pageToken: Optional[String] = Optional.Absent,
    includeInactive: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest = {
    import GetRelationalDatabaseBundlesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest
      .builder()
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .optionallyWith(includeInactive.map(value => value: java.lang.Boolean))(
        _.includeInactive
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseBundlesRequest.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseBundlesRequest
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseBundlesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseBundlesRequest =
      zio.aws.lightsail.model.GetRelationalDatabaseBundlesRequest(
        pageToken.map(value => value),
        includeInactive.map(value => value)
      )
    def pageToken: Optional[String]
    def includeInactive: Optional[Boolean]
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getIncludeInactive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeInactive", includeInactive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseBundlesRequest.ReadOnly {
    override val pageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => value: String)
    override val includeInactive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeInactive())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest
  ): zio.aws.lightsail.model.GetRelationalDatabaseBundlesRequest.ReadOnly =
    new Wrapper(impl)
}
