package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRelationalDatabaseParametersResponse(
    parameters: Optional[
      Iterable[zio.aws.lightsail.model.RelationalDatabaseParameter]
    ] = Optional.Absent,
    nextPageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse = {
    import GetRelationalDatabaseParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse
      .builder()
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseParametersResponse.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseParametersResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseParametersResponse =
      zio.aws.lightsail.model.GetRelationalDatabaseParametersResponse(
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def parameters: Optional[
      List[zio.aws.lightsail.model.RelationalDatabaseParameter.ReadOnly]
    ]
    def nextPageToken: Optional[String]
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.RelationalDatabaseParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseParametersResponse.ReadOnly {
    override val parameters: Optional[
      List[zio.aws.lightsail.model.RelationalDatabaseParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.RelationalDatabaseParameter.wrap(item)
        }.toList
      )
    override val nextPageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse
  ): zio.aws.lightsail.model.GetRelationalDatabaseParametersResponse.ReadOnly =
    new Wrapper(impl)
}
