package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRelationalDatabaseSnapshotResponse(
    relationalDatabaseSnapshot: Optional[
      zio.aws.lightsail.model.RelationalDatabaseSnapshot
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotResponse = {
    import GetRelationalDatabaseSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotResponse
      .builder()
      .optionallyWith(
        relationalDatabaseSnapshot.map(value => value.buildAwsValue())
      )(_.relationalDatabaseSnapshot)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseSnapshotResponse.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseSnapshotResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseSnapshotResponse =
      zio.aws.lightsail.model.GetRelationalDatabaseSnapshotResponse(
        relationalDatabaseSnapshot.map(value => value.asEditable)
      )
    def relationalDatabaseSnapshot
        : Optional[zio.aws.lightsail.model.RelationalDatabaseSnapshot.ReadOnly]
    def getRelationalDatabaseSnapshot: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.RelationalDatabaseSnapshot.ReadOnly
    ] = AwsError.unwrapOptionField(
      "relationalDatabaseSnapshot",
      relationalDatabaseSnapshot
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotResponse
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseSnapshotResponse.ReadOnly {
    override val relationalDatabaseSnapshot: Optional[
      zio.aws.lightsail.model.RelationalDatabaseSnapshot.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.relationalDatabaseSnapshot())
      .map(value =>
        zio.aws.lightsail.model.RelationalDatabaseSnapshot.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotResponse
  ): zio.aws.lightsail.model.GetRelationalDatabaseSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
