package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRelationalDatabasesResponse(
    relationalDatabases: Optional[
      Iterable[zio.aws.lightsail.model.RelationalDatabase]
    ] = Optional.Absent,
    nextPageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse = {
    import GetRelationalDatabasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse
      .builder()
      .optionallyWith(
        relationalDatabases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relationalDatabases)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabasesResponse.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabasesResponse.wrap(buildAwsValue())
}
object GetRelationalDatabasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetRelationalDatabasesResponse =
      zio.aws.lightsail.model.GetRelationalDatabasesResponse(
        relationalDatabases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def relationalDatabases
        : Optional[List[zio.aws.lightsail.model.RelationalDatabase.ReadOnly]]
    def nextPageToken: Optional[String]
    def getRelationalDatabases: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.RelationalDatabase.ReadOnly
    ]] = AwsError.unwrapOptionField("relationalDatabases", relationalDatabases)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse
  ) extends zio.aws.lightsail.model.GetRelationalDatabasesResponse.ReadOnly {
    override val relationalDatabases
        : Optional[List[zio.aws.lightsail.model.RelationalDatabase.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relationalDatabases())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.RelationalDatabase.wrap(item)
          }.toList
        )
    override val nextPageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse
  ): zio.aws.lightsail.model.GetRelationalDatabasesResponse.ReadOnly =
    new Wrapper(impl)
}
