package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetStaticIpResponse(
    staticIp: Optional[zio.aws.lightsail.model.StaticIp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse = {
    import GetStaticIpResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse
      .builder()
      .optionallyWith(staticIp.map(value => value.buildAwsValue()))(_.staticIp)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetStaticIpResponse.ReadOnly =
    zio.aws.lightsail.model.GetStaticIpResponse.wrap(buildAwsValue())
}
object GetStaticIpResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetStaticIpResponse =
      zio.aws.lightsail.model
        .GetStaticIpResponse(staticIp.map(value => value.asEditable))
    def staticIp: Optional[zio.aws.lightsail.model.StaticIp.ReadOnly]
    def getStaticIp
        : ZIO[Any, AwsError, zio.aws.lightsail.model.StaticIp.ReadOnly] =
      AwsError.unwrapOptionField("staticIp", staticIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse
  ) extends zio.aws.lightsail.model.GetStaticIpResponse.ReadOnly {
    override val staticIp: Optional[zio.aws.lightsail.model.StaticIp.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.staticIp())
        .map(value => zio.aws.lightsail.model.StaticIp.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse
  ): zio.aws.lightsail.model.GetStaticIpResponse.ReadOnly = new Wrapper(impl)
}
