package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceMetadataOptions(
    state: Optional[zio.aws.lightsail.model.InstanceMetadataState] =
      Optional.Absent,
    httpTokens: Optional[zio.aws.lightsail.model.HttpTokens] = Optional.Absent,
    httpEndpoint: Optional[zio.aws.lightsail.model.HttpEndpoint] =
      Optional.Absent,
    httpPutResponseHopLimit: Optional[Integer] = Optional.Absent,
    httpProtocolIpv6: Optional[zio.aws.lightsail.model.HttpProtocolIpv6] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceMetadataOptions = {
    import InstanceMetadataOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceMetadataOptions
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(httpTokens.map(value => value.unwrap))(_.httpTokens)
      .optionallyWith(httpEndpoint.map(value => value.unwrap))(_.httpEndpoint)
      .optionallyWith(
        httpPutResponseHopLimit.map(value => value: java.lang.Integer)
      )(_.httpPutResponseHopLimit)
      .optionallyWith(httpProtocolIpv6.map(value => value.unwrap))(
        _.httpProtocolIpv6
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.InstanceMetadataOptions.ReadOnly =
    zio.aws.lightsail.model.InstanceMetadataOptions.wrap(buildAwsValue())
}
object InstanceMetadataOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceMetadataOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.InstanceMetadataOptions =
      zio.aws.lightsail.model.InstanceMetadataOptions(
        state.map(value => value),
        httpTokens.map(value => value),
        httpEndpoint.map(value => value),
        httpPutResponseHopLimit.map(value => value),
        httpProtocolIpv6.map(value => value)
      )
    def state: Optional[zio.aws.lightsail.model.InstanceMetadataState]
    def httpTokens: Optional[zio.aws.lightsail.model.HttpTokens]
    def httpEndpoint: Optional[zio.aws.lightsail.model.HttpEndpoint]
    def httpPutResponseHopLimit: Optional[Integer]
    def httpProtocolIpv6: Optional[zio.aws.lightsail.model.HttpProtocolIpv6]
    def getState
        : ZIO[Any, AwsError, zio.aws.lightsail.model.InstanceMetadataState] =
      AwsError.unwrapOptionField("state", state)
    def getHttpTokens: ZIO[Any, AwsError, zio.aws.lightsail.model.HttpTokens] =
      AwsError.unwrapOptionField("httpTokens", httpTokens)
    def getHttpEndpoint
        : ZIO[Any, AwsError, zio.aws.lightsail.model.HttpEndpoint] =
      AwsError.unwrapOptionField("httpEndpoint", httpEndpoint)
    def getHttpPutResponseHopLimit: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("httpPutResponseHopLimit", httpPutResponseHopLimit)
    def getHttpProtocolIpv6
        : ZIO[Any, AwsError, zio.aws.lightsail.model.HttpProtocolIpv6] =
      AwsError.unwrapOptionField("httpProtocolIpv6", httpProtocolIpv6)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceMetadataOptions
  ) extends zio.aws.lightsail.model.InstanceMetadataOptions.ReadOnly {
    override val state
        : Optional[zio.aws.lightsail.model.InstanceMetadataState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.lightsail.model.InstanceMetadataState.wrap(value))
    override val httpTokens: Optional[zio.aws.lightsail.model.HttpTokens] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpTokens())
        .map(value => zio.aws.lightsail.model.HttpTokens.wrap(value))
    override val httpEndpoint: Optional[zio.aws.lightsail.model.HttpEndpoint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpEndpoint())
        .map(value => zio.aws.lightsail.model.HttpEndpoint.wrap(value))
    override val httpPutResponseHopLimit: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpPutResponseHopLimit())
        .map(value => value: Integer)
    override val httpProtocolIpv6
        : Optional[zio.aws.lightsail.model.HttpProtocolIpv6] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpProtocolIpv6())
        .map(value => zio.aws.lightsail.model.HttpProtocolIpv6.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceMetadataOptions
  ): zio.aws.lightsail.model.InstanceMetadataOptions.ReadOnly = new Wrapper(
    impl
  )
}
