package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  Integer,
  IsoDate,
  NonEmptyString,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class InstanceSnapshot(
    name: Optional[ResourceName] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    supportCode: Optional[String] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    location: Optional[zio.aws.lightsail.model.ResourceLocation] =
      Optional.Absent,
    resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent,
    state: Optional[zio.aws.lightsail.model.InstanceSnapshotState] =
      Optional.Absent,
    progress: Optional[String] = Optional.Absent,
    fromAttachedDisks: Optional[Iterable[zio.aws.lightsail.model.Disk]] =
      Optional.Absent,
    fromInstanceName: Optional[ResourceName] = Optional.Absent,
    fromInstanceArn: Optional[NonEmptyString] = Optional.Absent,
    fromBlueprintId: Optional[String] = Optional.Absent,
    fromBundleId: Optional[String] = Optional.Absent,
    isFromAutoSnapshot: Optional[Boolean] = Optional.Absent,
    sizeInGb: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceSnapshot = {
    import InstanceSnapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceSnapshot
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(
        fromAttachedDisks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fromAttachedDisks)
      .optionallyWith(
        fromInstanceName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.fromInstanceName)
      .optionallyWith(
        fromInstanceArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.fromInstanceArn)
      .optionallyWith(fromBlueprintId.map(value => value: java.lang.String))(
        _.fromBlueprintId
      )
      .optionallyWith(fromBundleId.map(value => value: java.lang.String))(
        _.fromBundleId
      )
      .optionallyWith(
        isFromAutoSnapshot.map(value => value: java.lang.Boolean)
      )(_.isFromAutoSnapshot)
      .optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(
        _.sizeInGb
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.InstanceSnapshot.ReadOnly =
    zio.aws.lightsail.model.InstanceSnapshot.wrap(buildAwsValue())
}
object InstanceSnapshot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceSnapshot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.InstanceSnapshot =
      zio.aws.lightsail.model.InstanceSnapshot(
        name.map(value => value),
        arn.map(value => value),
        supportCode.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        state.map(value => value),
        progress.map(value => value),
        fromAttachedDisks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fromInstanceName.map(value => value),
        fromInstanceArn.map(value => value),
        fromBlueprintId.map(value => value),
        fromBundleId.map(value => value),
        isFromAutoSnapshot.map(value => value),
        sizeInGb.map(value => value)
      )
    def name: Optional[ResourceName]
    def arn: Optional[NonEmptyString]
    def supportCode: Optional[String]
    def createdAt: Optional[IsoDate]
    def location: Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Optional[zio.aws.lightsail.model.ResourceType]
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def state: Optional[zio.aws.lightsail.model.InstanceSnapshotState]
    def progress: Optional[String]
    def fromAttachedDisks: Optional[List[zio.aws.lightsail.model.Disk.ReadOnly]]
    def fromInstanceName: Optional[ResourceName]
    def fromInstanceArn: Optional[NonEmptyString]
    def fromBlueprintId: Optional[String]
    def fromBundleId: Optional[String]
    def isFromAutoSnapshot: Optional[Boolean]
    def sizeInGb: Optional[Integer]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getState
        : ZIO[Any, AwsError, zio.aws.lightsail.model.InstanceSnapshotState] =
      AwsError.unwrapOptionField("state", state)
    def getProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progress)
    def getFromAttachedDisks
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Disk.ReadOnly]] =
      AwsError.unwrapOptionField("fromAttachedDisks", fromAttachedDisks)
    def getFromInstanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("fromInstanceName", fromInstanceName)
    def getFromInstanceArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fromInstanceArn", fromInstanceArn)
    def getFromBlueprintId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fromBlueprintId", fromBlueprintId)
    def getFromBundleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fromBundleId", fromBundleId)
    def getIsFromAutoSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isFromAutoSnapshot", isFromAutoSnapshot)
    def getSizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sizeInGb", sizeInGb)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceSnapshot
  ) extends zio.aws.lightsail.model.InstanceSnapshot.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val supportCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supportCode())
      .map(value => value: String)
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val state
        : Optional[zio.aws.lightsail.model.InstanceSnapshotState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.lightsail.model.InstanceSnapshotState.wrap(value))
    override val progress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.progress())
      .map(value => value: String)
    override val fromAttachedDisks
        : Optional[List[zio.aws.lightsail.model.Disk.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fromAttachedDisks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Disk.wrap(item)
          }.toList
        )
    override val fromInstanceName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fromInstanceName())
        .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val fromInstanceArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fromInstanceArn())
        .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val fromBlueprintId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fromBlueprintId())
      .map(value => value: String)
    override val fromBundleId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fromBundleId())
      .map(value => value: String)
    override val isFromAutoSnapshot: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isFromAutoSnapshot())
      .map(value => value: Boolean)
    override val sizeInGb: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeInGb())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceSnapshot
  ): zio.aws.lightsail.model.InstanceSnapshot.ReadOnly = new Wrapper(impl)
}
