package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  Base64,
  IsoDate,
  NonEmptyString,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class KeyPair(
    name: Optional[ResourceName] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    supportCode: Optional[String] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    location: Optional[zio.aws.lightsail.model.ResourceLocation] =
      Optional.Absent,
    resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent,
    fingerprint: Optional[Base64] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.KeyPair = {
    import KeyPair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.KeyPair
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        fingerprint.map(value => Base64.unwrap(value): java.lang.String)
      )(_.fingerprint)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.KeyPair.ReadOnly =
    zio.aws.lightsail.model.KeyPair.wrap(buildAwsValue())
}
object KeyPair {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.KeyPair] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.KeyPair =
      zio.aws.lightsail.model.KeyPair(
        name.map(value => value),
        arn.map(value => value),
        supportCode.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fingerprint.map(value => value)
      )
    def name: Optional[ResourceName]
    def arn: Optional[NonEmptyString]
    def supportCode: Optional[String]
    def createdAt: Optional[IsoDate]
    def location: Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Optional[zio.aws.lightsail.model.ResourceType]
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def fingerprint: Optional[Base64]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getFingerprint: ZIO[Any, AwsError, Base64] =
      AwsError.unwrapOptionField("fingerprint", fingerprint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.KeyPair
  ) extends zio.aws.lightsail.model.KeyPair.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val supportCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supportCode())
      .map(value => value: String)
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val fingerprint: Optional[Base64] = zio.aws.core.internal
      .optionalFromNullable(impl.fingerprint())
      .map(value => zio.aws.lightsail.model.primitives.Base64(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.KeyPair
  ): zio.aws.lightsail.model.KeyPair.ReadOnly = new Wrapper(impl)
}
