package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait LoadBalancerProtocol {
  def unwrap
      : software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol
}
object LoadBalancerProtocol {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol
  ): zio.aws.lightsail.model.LoadBalancerProtocol = value match {
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol.HTTP_HTTPS =>
      val r = HTTP_HTTPS
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol.HTTP =>
      val r = HTTP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.LoadBalancerProtocol {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol =
      software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object HTTP_HTTPS extends zio.aws.lightsail.model.LoadBalancerProtocol {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol =
      software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol.HTTP_HTTPS
  }
  case object HTTP extends zio.aws.lightsail.model.LoadBalancerProtocol {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol =
      software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol.HTTP
  }
}
