package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  IsoDate,
  ResourceName,
  NonEmptyString
}
import scala.jdk.CollectionConverters._
final case class Operation(
    id: Optional[NonEmptyString] = Optional.Absent,
    resourceName: Optional[ResourceName] = Optional.Absent,
    resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    location: Optional[zio.aws.lightsail.model.ResourceLocation] =
      Optional.Absent,
    isTerminal: Optional[Boolean] = Optional.Absent,
    operationDetails: Optional[String] = Optional.Absent,
    operationType: Optional[zio.aws.lightsail.model.OperationType] =
      Optional.Absent,
    status: Optional[zio.aws.lightsail.model.OperationStatus] = Optional.Absent,
    statusChangedAt: Optional[IsoDate] = Optional.Absent,
    errorCode: Optional[String] = Optional.Absent,
    errorDetails: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Operation = {
    import Operation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Operation
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(isTerminal.map(value => value: java.lang.Boolean))(
        _.isTerminal
      )
      .optionallyWith(operationDetails.map(value => value: java.lang.String))(
        _.operationDetails
      )
      .optionallyWith(operationType.map(value => value.unwrap))(_.operationType)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusChangedAt.map(value => IsoDate.unwrap(value): Instant)
      )(_.statusChangedAt)
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorDetails.map(value => value: java.lang.String))(
        _.errorDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Operation.ReadOnly =
    zio.aws.lightsail.model.Operation.wrap(buildAwsValue())
}
object Operation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.Operation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Operation =
      zio.aws.lightsail.model.Operation(
        id.map(value => value),
        resourceName.map(value => value),
        resourceType.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        isTerminal.map(value => value),
        operationDetails.map(value => value),
        operationType.map(value => value),
        status.map(value => value),
        statusChangedAt.map(value => value),
        errorCode.map(value => value),
        errorDetails.map(value => value)
      )
    def id: Optional[NonEmptyString]
    def resourceName: Optional[ResourceName]
    def resourceType: Optional[zio.aws.lightsail.model.ResourceType]
    def createdAt: Optional[IsoDate]
    def location: Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def isTerminal: Optional[Boolean]
    def operationDetails: Optional[String]
    def operationType: Optional[zio.aws.lightsail.model.OperationType]
    def status: Optional[zio.aws.lightsail.model.OperationStatus]
    def statusChangedAt: Optional[IsoDate]
    def errorCode: Optional[String]
    def errorDetails: Optional[String]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getIsTerminal: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isTerminal", isTerminal)
    def getOperationDetails: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operationDetails", operationDetails)
    def getOperationType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.OperationType] =
      AwsError.unwrapOptionField("operationType", operationType)
    def getStatus: ZIO[Any, AwsError, zio.aws.lightsail.model.OperationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusChangedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("statusChangedAt", statusChangedAt)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorDetails: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorDetails", errorDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Operation
  ) extends zio.aws.lightsail.model.Operation.ReadOnly {
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val resourceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val isTerminal: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isTerminal())
      .map(value => value: Boolean)
    override val operationDetails: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.operationDetails())
      .map(value => value: String)
    override val operationType
        : Optional[zio.aws.lightsail.model.OperationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationType())
        .map(value => zio.aws.lightsail.model.OperationType.wrap(value))
    override val status: Optional[zio.aws.lightsail.model.OperationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.lightsail.model.OperationStatus.wrap(value))
    override val statusChangedAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.statusChangedAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val errorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: String)
    override val errorDetails: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorDetails())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Operation
  ): zio.aws.lightsail.model.Operation.ReadOnly = new Wrapper(impl)
}
