package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class QueryStringObject(
    option: Optional[Boolean] = Optional.Absent,
    queryStringsAllowList: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.QueryStringObject = {
    import QueryStringObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.QueryStringObject
      .builder()
      .optionallyWith(option.map(value => value: java.lang.Boolean))(_.option)
      .optionallyWith(
        queryStringsAllowList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.queryStringsAllowList)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.QueryStringObject.ReadOnly =
    zio.aws.lightsail.model.QueryStringObject.wrap(buildAwsValue())
}
object QueryStringObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.QueryStringObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.QueryStringObject =
      zio.aws.lightsail.model.QueryStringObject(
        option.map(value => value),
        queryStringsAllowList.map(value => value)
      )
    def option: Optional[Boolean]
    def queryStringsAllowList: Optional[List[String]]
    def getOption: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("option", option)
    def getQueryStringsAllowList: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("queryStringsAllowList", queryStringsAllowList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.QueryStringObject
  ) extends zio.aws.lightsail.model.QueryStringObject.ReadOnly {
    override val option: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.option())
      .map(value => value: Boolean)
    override val queryStringsAllowList: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryStringsAllowList())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.QueryStringObject
  ): zio.aws.lightsail.model.QueryStringObject.ReadOnly = new Wrapper(impl)
}
