package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RelationalDatabaseParameter(
    allowedValues: Optional[String] = Optional.Absent,
    applyMethod: Optional[String] = Optional.Absent,
    applyType: Optional[String] = Optional.Absent,
    dataType: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    isModifiable: Optional[Boolean] = Optional.Absent,
    parameterName: Optional[String] = Optional.Absent,
    parameterValue: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter = {
    import RelationalDatabaseParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter
      .builder()
      .optionallyWith(allowedValues.map(value => value: java.lang.String))(
        _.allowedValues
      )
      .optionallyWith(applyMethod.map(value => value: java.lang.String))(
        _.applyMethod
      )
      .optionallyWith(applyType.map(value => value: java.lang.String))(
        _.applyType
      )
      .optionallyWith(dataType.map(value => value: java.lang.String))(
        _.dataType
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(isModifiable.map(value => value: java.lang.Boolean))(
        _.isModifiable
      )
      .optionallyWith(parameterName.map(value => value: java.lang.String))(
        _.parameterName
      )
      .optionallyWith(parameterValue.map(value => value: java.lang.String))(
        _.parameterValue
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.RelationalDatabaseParameter.ReadOnly =
    zio.aws.lightsail.model.RelationalDatabaseParameter.wrap(buildAwsValue())
}
object RelationalDatabaseParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RelationalDatabaseParameter =
      zio.aws.lightsail.model.RelationalDatabaseParameter(
        allowedValues.map(value => value),
        applyMethod.map(value => value),
        applyType.map(value => value),
        dataType.map(value => value),
        description.map(value => value),
        isModifiable.map(value => value),
        parameterName.map(value => value),
        parameterValue.map(value => value)
      )
    def allowedValues: Optional[String]
    def applyMethod: Optional[String]
    def applyType: Optional[String]
    def dataType: Optional[String]
    def description: Optional[String]
    def isModifiable: Optional[Boolean]
    def parameterName: Optional[String]
    def parameterValue: Optional[String]
    def getAllowedValues: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getApplyMethod: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("applyMethod", applyMethod)
    def getApplyType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("applyType", applyType)
    def getDataType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataType", dataType)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getIsModifiable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isModifiable", isModifiable)
    def getParameterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterName", parameterName)
    def getParameterValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterValue", parameterValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter
  ) extends zio.aws.lightsail.model.RelationalDatabaseParameter.ReadOnly {
    override val allowedValues: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.allowedValues())
      .map(value => value: String)
    override val applyMethod: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.applyMethod())
      .map(value => value: String)
    override val applyType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.applyType())
      .map(value => value: String)
    override val dataType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataType())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val isModifiable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isModifiable())
      .map(value => value: Boolean)
    override val parameterName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterName())
      .map(value => value: String)
    override val parameterValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterValue())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter
  ): zio.aws.lightsail.model.RelationalDatabaseParameter.ReadOnly = new Wrapper(
    impl
  )
}
