package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ReleaseStaticIpRequest(staticIpName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest = {
    import ReleaseStaticIpRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest
      .builder()
      .staticIpName(ResourceName.unwrap(staticIpName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ReleaseStaticIpRequest.ReadOnly =
    zio.aws.lightsail.model.ReleaseStaticIpRequest.wrap(buildAwsValue())
}
object ReleaseStaticIpRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ReleaseStaticIpRequest =
      zio.aws.lightsail.model.ReleaseStaticIpRequest(staticIpName)
    def staticIpName: ResourceName
    def getStaticIpName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(staticIpName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest
  ) extends zio.aws.lightsail.model.ReleaseStaticIpRequest.ReadOnly {
    override val staticIpName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.staticIpName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest
  ): zio.aws.lightsail.model.ReleaseStaticIpRequest.ReadOnly = new Wrapper(impl)
}
