package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{IsoDate, RenewalStatusReason}
import scala.jdk.CollectionConverters._
final case class RenewalSummary(
    domainValidationRecords: Optional[
      Iterable[zio.aws.lightsail.model.DomainValidationRecord]
    ] = Optional.Absent,
    renewalStatus: Optional[zio.aws.lightsail.model.RenewalStatus] =
      Optional.Absent,
    renewalStatusReason: Optional[RenewalStatusReason] = Optional.Absent,
    updatedAt: Optional[IsoDate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RenewalSummary = {
    import RenewalSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RenewalSummary
      .builder()
      .optionallyWith(
        domainValidationRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainValidationRecords)
      .optionallyWith(renewalStatus.map(value => value.unwrap))(_.renewalStatus)
      .optionallyWith(
        renewalStatusReason.map(value =>
          RenewalStatusReason.unwrap(value): java.lang.String
        )
      )(_.renewalStatusReason)
      .optionallyWith(updatedAt.map(value => IsoDate.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.RenewalSummary.ReadOnly =
    zio.aws.lightsail.model.RenewalSummary.wrap(buildAwsValue())
}
object RenewalSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RenewalSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RenewalSummary =
      zio.aws.lightsail.model.RenewalSummary(
        domainValidationRecords.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        renewalStatus.map(value => value),
        renewalStatusReason.map(value => value),
        updatedAt.map(value => value)
      )
    def domainValidationRecords: Optional[
      List[zio.aws.lightsail.model.DomainValidationRecord.ReadOnly]
    ]
    def renewalStatus: Optional[zio.aws.lightsail.model.RenewalStatus]
    def renewalStatusReason: Optional[RenewalStatusReason]
    def updatedAt: Optional[IsoDate]
    def getDomainValidationRecords: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.DomainValidationRecord.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainValidationRecords",
      domainValidationRecords
    )
    def getRenewalStatus
        : ZIO[Any, AwsError, zio.aws.lightsail.model.RenewalStatus] =
      AwsError.unwrapOptionField("renewalStatus", renewalStatus)
    def getRenewalStatusReason: ZIO[Any, AwsError, RenewalStatusReason] =
      AwsError.unwrapOptionField("renewalStatusReason", renewalStatusReason)
    def getUpdatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RenewalSummary
  ) extends zio.aws.lightsail.model.RenewalSummary.ReadOnly {
    override val domainValidationRecords: Optional[
      List[zio.aws.lightsail.model.DomainValidationRecord.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.domainValidationRecords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.DomainValidationRecord.wrap(item)
        }.toList
      )
    override val renewalStatus
        : Optional[zio.aws.lightsail.model.RenewalStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.renewalStatus())
        .map(value => zio.aws.lightsail.model.RenewalStatus.wrap(value))
    override val renewalStatusReason: Optional[RenewalStatusReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.renewalStatusReason())
        .map(value =>
          zio.aws.lightsail.model.primitives.RenewalStatusReason(value)
        )
    override val updatedAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RenewalSummary
  ): zio.aws.lightsail.model.RenewalSummary.ReadOnly = new Wrapper(impl)
}
