package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceLocation(
    availabilityZone: Optional[String] = Optional.Absent,
    regionName: Optional[zio.aws.lightsail.model.RegionName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ResourceLocation = {
    import ResourceLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ResourceLocation
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(regionName.map(value => value.unwrap))(_.regionName)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ResourceLocation.ReadOnly =
    zio.aws.lightsail.model.ResourceLocation.wrap(buildAwsValue())
}
object ResourceLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ResourceLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ResourceLocation =
      zio.aws.lightsail.model.ResourceLocation(
        availabilityZone.map(value => value),
        regionName.map(value => value)
      )
    def availabilityZone: Optional[String]
    def regionName: Optional[zio.aws.lightsail.model.RegionName]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getRegionName: ZIO[Any, AwsError, zio.aws.lightsail.model.RegionName] =
      AwsError.unwrapOptionField("regionName", regionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ResourceLocation
  ) extends zio.aws.lightsail.model.ResourceLocation.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val regionName: Optional[zio.aws.lightsail.model.RegionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regionName())
        .map(value => zio.aws.lightsail.model.RegionName.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ResourceLocation
  ): zio.aws.lightsail.model.ResourceLocation.ReadOnly = new Wrapper(impl)
}
