package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.lightsail.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.ResourceType
  ): zio.aws.lightsail.model.ResourceType = value match {
    case software.amazon.awssdk.services.lightsail.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.CONTAINER_SERVICE =>
      val r = ContainerService
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.INSTANCE =>
      val r = Instance
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.STATIC_IP =>
      val r = StaticIp
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.KEY_PAIR =>
      val r = KeyPair
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.INSTANCE_SNAPSHOT =>
      val r = InstanceSnapshot
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.DOMAIN =>
      val r = Domain
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.PEERED_VPC =>
      val r = PeeredVpc
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.LOAD_BALANCER =>
      val r = LoadBalancer
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.LOAD_BALANCER_TLS_CERTIFICATE =>
      val r = LoadBalancerTlsCertificate
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.DISK =>
      val r = Disk
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.DISK_SNAPSHOT =>
      val r = DiskSnapshot
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.RELATIONAL_DATABASE =>
      val r = RelationalDatabase
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.RELATIONAL_DATABASE_SNAPSHOT =>
      val r = RelationalDatabaseSnapshot
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.EXPORT_SNAPSHOT_RECORD =>
      val r = ExportSnapshotRecord
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.CLOUD_FORMATION_STACK_RECORD =>
      val r = CloudFormationStackRecord
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.ALARM =>
      val r = Alarm
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.CONTACT_METHOD =>
      val r = ContactMethod
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.DISTRIBUTION =>
      val r = Distribution
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.CERTIFICATE =>
      val r = Certificate
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceType.BUCKET =>
      val r = Bucket
      r
  }
  case object unknownToSdkVersion extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ContainerService extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.CONTAINER_SERVICE
  }
  case object Instance extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.INSTANCE
  }
  case object StaticIp extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.STATIC_IP
  }
  case object KeyPair extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.KEY_PAIR
  }
  case object InstanceSnapshot extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.INSTANCE_SNAPSHOT
  }
  case object Domain extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.DOMAIN
  }
  case object PeeredVpc extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.PEERED_VPC
  }
  case object LoadBalancer extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.LOAD_BALANCER
  }
  case object LoadBalancerTlsCertificate
      extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.LOAD_BALANCER_TLS_CERTIFICATE
  }
  case object Disk extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.DISK
  }
  case object DiskSnapshot extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.DISK_SNAPSHOT
  }
  case object RelationalDatabase extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.RELATIONAL_DATABASE
  }
  case object RelationalDatabaseSnapshot
      extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.RELATIONAL_DATABASE_SNAPSHOT
  }
  case object ExportSnapshotRecord
      extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.EXPORT_SNAPSHOT_RECORD
  }
  case object CloudFormationStackRecord
      extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.CLOUD_FORMATION_STACK_RECORD
  }
  case object Alarm extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.ALARM
  }
  case object ContactMethod extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.CONTACT_METHOD
  }
  case object Distribution extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.DISTRIBUTION
  }
  case object Certificate extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.CERTIFICATE
  }
  case object Bucket extends zio.aws.lightsail.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceType =
      software.amazon.awssdk.services.lightsail.model.ResourceType.BUCKET
  }
}
