package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopRelationalDatabaseRequest(
    relationalDatabaseName: ResourceName,
    relationalDatabaseSnapshotName: Optional[ResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest = {
    import StopRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest
      .builder()
      .relationalDatabaseName(
        ResourceName.unwrap(relationalDatabaseName): java.lang.String
      )
      .optionallyWith(
        relationalDatabaseSnapshotName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.relationalDatabaseSnapshotName)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.StopRelationalDatabaseRequest.ReadOnly =
    zio.aws.lightsail.model.StopRelationalDatabaseRequest.wrap(buildAwsValue())
}
object StopRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.StopRelationalDatabaseRequest =
      zio.aws.lightsail.model.StopRelationalDatabaseRequest(
        relationalDatabaseName,
        relationalDatabaseSnapshotName.map(value => value)
      )
    def relationalDatabaseName: ResourceName
    def relationalDatabaseSnapshotName: Optional[ResourceName]
    def getRelationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseName)
    def getRelationalDatabaseSnapshotName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField(
        "relationalDatabaseSnapshotName",
        relationalDatabaseSnapshotName
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest
  ) extends zio.aws.lightsail.model.StopRelationalDatabaseRequest.ReadOnly {
    override val relationalDatabaseName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseName())
    override val relationalDatabaseSnapshotName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relationalDatabaseSnapshotName())
        .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest
  ): zio.aws.lightsail.model.StopRelationalDatabaseRequest.ReadOnly =
    new Wrapper(impl)
}
