package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDistributionRequest(
    distributionName: ResourceName,
    origin: Optional[zio.aws.lightsail.model.InputOrigin] = Optional.Absent,
    defaultCacheBehavior: Optional[zio.aws.lightsail.model.CacheBehavior] =
      Optional.Absent,
    cacheBehaviorSettings: Optional[zio.aws.lightsail.model.CacheSettings] =
      Optional.Absent,
    cacheBehaviors: Optional[
      Iterable[zio.aws.lightsail.model.CacheBehaviorPerPath]
    ] = Optional.Absent,
    isEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest = {
    import UpdateDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest
      .builder()
      .distributionName(ResourceName.unwrap(distributionName): java.lang.String)
      .optionallyWith(origin.map(value => value.buildAwsValue()))(_.origin)
      .optionallyWith(defaultCacheBehavior.map(value => value.buildAwsValue()))(
        _.defaultCacheBehavior
      )
      .optionallyWith(
        cacheBehaviorSettings.map(value => value.buildAwsValue())
      )(_.cacheBehaviorSettings)
      .optionallyWith(
        cacheBehaviors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheBehaviors)
      .optionallyWith(isEnabled.map(value => value: java.lang.Boolean))(
        _.isEnabled
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.UpdateDistributionRequest.ReadOnly =
    zio.aws.lightsail.model.UpdateDistributionRequest.wrap(buildAwsValue())
}
object UpdateDistributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.UpdateDistributionRequest =
      zio.aws.lightsail.model.UpdateDistributionRequest(
        distributionName,
        origin.map(value => value.asEditable),
        defaultCacheBehavior.map(value => value.asEditable),
        cacheBehaviorSettings.map(value => value.asEditable),
        cacheBehaviors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isEnabled.map(value => value)
      )
    def distributionName: ResourceName
    def origin: Optional[zio.aws.lightsail.model.InputOrigin.ReadOnly]
    def defaultCacheBehavior
        : Optional[zio.aws.lightsail.model.CacheBehavior.ReadOnly]
    def cacheBehaviorSettings
        : Optional[zio.aws.lightsail.model.CacheSettings.ReadOnly]
    def cacheBehaviors
        : Optional[List[zio.aws.lightsail.model.CacheBehaviorPerPath.ReadOnly]]
    def isEnabled: Optional[Boolean]
    def getDistributionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(distributionName)
    def getOrigin
        : ZIO[Any, AwsError, zio.aws.lightsail.model.InputOrigin.ReadOnly] =
      AwsError.unwrapOptionField("origin", origin)
    def getDefaultCacheBehavior
        : ZIO[Any, AwsError, zio.aws.lightsail.model.CacheBehavior.ReadOnly] =
      AwsError.unwrapOptionField("defaultCacheBehavior", defaultCacheBehavior)
    def getCacheBehaviorSettings
        : ZIO[Any, AwsError, zio.aws.lightsail.model.CacheSettings.ReadOnly] =
      AwsError.unwrapOptionField("cacheBehaviorSettings", cacheBehaviorSettings)
    def getCacheBehaviors: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.CacheBehaviorPerPath.ReadOnly
    ]] = AwsError.unwrapOptionField("cacheBehaviors", cacheBehaviors)
    def getIsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isEnabled", isEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest
  ) extends zio.aws.lightsail.model.UpdateDistributionRequest.ReadOnly {
    override val distributionName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.distributionName())
    override val origin
        : Optional[zio.aws.lightsail.model.InputOrigin.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.origin())
        .map(value => zio.aws.lightsail.model.InputOrigin.wrap(value))
    override val defaultCacheBehavior
        : Optional[zio.aws.lightsail.model.CacheBehavior.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultCacheBehavior())
        .map(value => zio.aws.lightsail.model.CacheBehavior.wrap(value))
    override val cacheBehaviorSettings
        : Optional[zio.aws.lightsail.model.CacheSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheBehaviorSettings())
        .map(value => zio.aws.lightsail.model.CacheSettings.wrap(value))
    override val cacheBehaviors: Optional[
      List[zio.aws.lightsail.model.CacheBehaviorPerPath.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheBehaviors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.CacheBehaviorPerPath.wrap(item)
        }.toList
      )
    override val isEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isEnabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest
  ): zio.aws.lightsail.model.UpdateDistributionRequest.ReadOnly = new Wrapper(
    impl
  )
}
