/*
 * Decompiled with CFR 0.152.
 */
package zio.aws.netty.descriptors;

import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslProvider;
import java.io.Serializable;
import java.time.Duration;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple14;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.utils.AttributeMap;
import zio.Chunk;
import zio.Config;
import zio.Config$;
import zio.DurationSyntax$;
import zio.Zippable$;
import zio.aws.core.httpclient.ChannelOptions;
import zio.aws.core.httpclient.Protocol;
import zio.aws.netty.Http2Config;
import zio.aws.netty.Http2Config$;
import zio.aws.netty.HttpOrHttps;
import zio.aws.netty.HttpOrHttps$Http$;
import zio.aws.netty.HttpOrHttps$Https$;
import zio.aws.netty.NettyChannelOptions;
import zio.aws.netty.NettyChannelOptions$;
import zio.aws.netty.NettyClientConfig;
import zio.aws.netty.NettyClientConfig$;
import zio.aws.netty.NettyOptionValue;
import zio.aws.netty.NettyOptionValue$;
import zio.aws.netty.ProxyConfiguration;
import zio.aws.netty.ProxyConfiguration$;

public final class package$
implements Serializable {
    private static final Config httpOrHttps;
    private static final Config proxyConfiguration;
    private static final Config http2Configuration;
    private static final Config nettyChannelOptions;
    private static final Config protocol;
    private static final Config sslProvider;
    private static final Config nettyClientConfig;
    public static final package$ MODULE$;

    private package$() {
    }

    static {
        MODULE$ = new package$();
        httpOrHttps = Config$.MODULE$.string().mapOrFail((Function1 & Serializable)x$1 -> {
            String string = x$1;
            if ("http".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)HttpOrHttps$Http$.MODULE$);
            }
            if ("https".equals(string)) {
                return scala.package$.MODULE$.Right().apply((Object)HttpOrHttps$Https$.MODULE$);
            }
            if (string != null) {
                String other = string;
                String string2 = new StringBuilder(37).append("Invalid value ").append(other).append(". Use 'http' or 'https'").toString();
                Chunk chunk = Config.Error$.InvalidData$.MODULE$.$lessinit$greater$default$1();
                return scala.package$.MODULE$.Left().apply((Object)Config.Error$.InvalidData$.MODULE$.apply(chunk, string2));
            }
            throw new MatchError((Object)string);
        });
        proxyConfiguration = MODULE$.httpOrHttps().nested(MODULE$::$init$$$anonfun$2).withDefault(MODULE$::$init$$$anonfun$3).$qmark$qmark(MODULE$::$init$$$anonfun$4).zip(MODULE$::$init$$$anonfun$5, Zippable$.MODULE$.Zippable2()).zip(MODULE$::$init$$$anonfun$6, Zippable$.MODULE$.Zippable3()).zip(MODULE$::$init$$$anonfun$7, Zippable$.MODULE$.Zippable4()).map((Function1 & Serializable)x$1 -> {
            Tuple4 tuple4 = x$1;
            if (tuple4 != null) {
                HttpOrHttps scheme = (HttpOrHttps)tuple4._1();
                String host = (String)tuple4._2();
                int port = BoxesRunTime.unboxToInt((Object)tuple4._3());
                Set nonProxyHosts = (Set)tuple4._4();
                return ProxyConfiguration$.MODULE$.apply(scheme, host, port, (Set<String>)nonProxyHosts);
            }
            throw new MatchError((Object)tuple4);
        });
        http2Configuration = Config$.MODULE$.int("maxStreams").$qmark$qmark(MODULE$::$init$$$anonfun$9).zip(MODULE$::$init$$$anonfun$10, Zippable$.MODULE$.Zippable2()).zip(MODULE$::$init$$$anonfun$11, Zippable$.MODULE$.Zippable3()).map((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                int maxStreams = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int initialWindowSize = BoxesRunTime.unboxToInt((Object)tuple3._2());
                Duration healthCheckPingPeriod = (Duration)tuple3._3();
                return Http2Config$.MODULE$.apply(Int$.MODULE$.int2long(maxStreams), initialWindowSize, healthCheckPingPeriod);
            }
            throw new MatchError((Object)tuple3);
        });
        Config socketChannelOptions = zio.aws.core.httpclient.descriptors.package$.MODULE$.channelOptions();
        Config channelOptions = MODULE$.durationMsChannelOption((ChannelOption<Integer>)ChannelOption.CONNECT_TIMEOUT_MILLIS).$qmark$qmark(MODULE$::$anonfun$1).zip(MODULE$::$anonfun$2, Zippable$.MODULE$.Zippable2()).zip(MODULE$::$anonfun$3, Zippable$.MODULE$.Zippable3()).zip(MODULE$::$anonfun$4, Zippable$.MODULE$.Zippable4()).zip(MODULE$::$anonfun$5, Zippable$.MODULE$.Zippable5()).zip(MODULE$::$anonfun$6, Zippable$.MODULE$.Zippable6()).map((Function1 & Serializable)tuple -> NettyChannelOptions$.MODULE$.apply(tuple.productIterator().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Object x) {
                Object object;
                Object object2 = x;
                if (object2 instanceof Some && (object = ((Some)object2).value()) instanceof NettyOptionValue) {
                    NettyOptionValue opt = (NettyOptionValue)object;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof Some && (object = ((Some)object2).value()) instanceof NettyOptionValue) {
                    NettyOptionValue opt = (NettyOptionValue)object;
                    return opt;
                }
                return function1.apply(x);
            }
        }).toVector()));
        nettyChannelOptions = socketChannelOptions.zip(() -> MODULE$.$init$$$anonfun$13(channelOptions), Zippable$.MODULE$.Zippable2()).mapOrFail((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ChannelOptions opts1 = (ChannelOptions)tuple2._1();
                NettyChannelOptions opts2 = (NettyChannelOptions)tuple2._2();
                return scala.package$.MODULE$.Right().apply((Object)opts2.withSocketOptions(opts1));
            }
            throw new MatchError((Object)tuple2);
        });
        protocol = Config$.MODULE$.string().mapOrFail((Function1 & Serializable)x$1 -> {
            String string = x$1;
            switch (string == null ? 0 : string.hashCode()) {
                case 2141340: {
                    if (!"Dual".equals(string)) break;
                    return scala.package$.MODULE$.Right().apply((Object)Protocol.Dual$.MODULE$);
                }
                case 649369517: {
                    if (!"HTTP/1.1".equals(string)) break;
                    return scala.package$.MODULE$.Right().apply((Object)Protocol.Http11$.MODULE$);
                }
                case 2141455467: {
                    if (!"HTTP/2".equals(string)) break;
                    return scala.package$.MODULE$.Right().apply((Object)Protocol.Http2$.MODULE$);
                }
            }
            if (string != null) {
                String other = string;
                String string2 = new StringBuilder(58).append("Invalid protocol: '").append(other).append("'. Use 'HTTP/1.1' or 'HTTP/2' or 'Dual'").toString();
                Chunk chunk = Config.Error$.InvalidData$.MODULE$.$lessinit$greater$default$1();
                return scala.package$.MODULE$.Left().apply((Object)Config.Error$.InvalidData$.MODULE$.apply(chunk, string2));
            }
            throw new MatchError((Object)string);
        });
        sslProvider = Config$.MODULE$.string().mapOrFail((Function1 & Serializable)x$1 -> {
            String string = x$1;
            switch (string == null ? 0 : string.hashCode()) {
                case -545192094: {
                    if (!"OPENSSL".equals(string)) break;
                    return scala.package$.MODULE$.Right().apply((Object)SslProvider.OPENSSL);
                }
                case -82390157: {
                    if (!"OPENSSL_REFCNT".equals(string)) break;
                    return scala.package$.MODULE$.Right().apply((Object)SslProvider.OPENSSL_REFCNT);
                }
                case 73297: {
                    if (!"JDK".equals(string)) break;
                    return scala.package$.MODULE$.Right().apply((Object)SslProvider.JDK);
                }
            }
            if (string != null) {
                String other = string;
                String string2 = new StringBuilder(66).append("Invalid SSL provider: '").append(other).append("'. Use 'JDK', 'OPENSSL' or 'OPENSSL_REFCNT'").toString();
                Chunk chunk = Config.Error$.InvalidData$.MODULE$.$lessinit$greater$default$1();
                return scala.package$.MODULE$.Left().apply((Object)Config.Error$.InvalidData$.MODULE$.apply(chunk, string2));
            }
            throw new MatchError((Object)string);
        });
        nettyClientConfig = Config$.MODULE$.int("maxConcurrency").withDefault(MODULE$::$init$$$anonfun$17).$qmark$qmark(MODULE$::$init$$$anonfun$18).zip(MODULE$::$init$$$anonfun$19, Zippable$.MODULE$.Zippable2()).zip(MODULE$::$init$$$anonfun$20, Zippable$.MODULE$.Zippable3()).zip(MODULE$::$init$$$anonfun$21, Zippable$.MODULE$.Zippable4()).zip(MODULE$::$init$$$anonfun$22, Zippable$.MODULE$.Zippable5()).zip(MODULE$::$init$$$anonfun$23, Zippable$.MODULE$.Zippable6()).zip(MODULE$::$init$$$anonfun$24, Zippable$.MODULE$.Zippable7()).zip(MODULE$::$init$$$anonfun$25, Zippable$.MODULE$.Zippable8()).zip(MODULE$::$init$$$anonfun$26, Zippable$.MODULE$.Zippable9()).zip(MODULE$::$init$$$anonfun$27, Zippable$.MODULE$.Zippable10()).zip(MODULE$::$init$$$anonfun$28, Zippable$.MODULE$.Zippable11()).zip(MODULE$::$init$$$anonfun$29, Zippable$.MODULE$.Zippable12()).zip(MODULE$::$init$$$anonfun$30, Zippable$.MODULE$.Zippable13()).zip(MODULE$::$init$$$anonfun$31, Zippable$.MODULE$.Zippable14()).map((Function1 & Serializable)x$1 -> {
            Tuple14 tuple14 = x$1;
            if (tuple14 != null) {
                int maxConcurrency = BoxesRunTime.unboxToInt((Object)tuple14._1());
                int maxPendingConnectionAcquires = BoxesRunTime.unboxToInt((Object)tuple14._2());
                Duration readTimeout = (Duration)tuple14._3();
                Duration writeTimeout = (Duration)tuple14._4();
                Duration connectionTimeout = (Duration)tuple14._5();
                Duration connectionAcquisitionTimeout = (Duration)tuple14._6();
                Duration connectionTimeToLive = (Duration)tuple14._7();
                Duration connectionMaxIdleTime = (Duration)tuple14._8();
                boolean useIdleConnectionReaper = BoxesRunTime.unboxToBoolean((Object)tuple14._9());
                Protocol protocol = (Protocol)tuple14._10();
                NettyChannelOptions channelOptions = (NettyChannelOptions)tuple14._11();
                Option sslProvider = (Option)tuple14._12();
                Option proxyConfiguration = (Option)tuple14._13();
                Option http2Configuration = (Option)tuple14._14();
                return NettyClientConfig$.MODULE$.apply(maxConcurrency, maxPendingConnectionAcquires, readTimeout, writeTimeout, connectionTimeout, connectionAcquisitionTimeout, connectionTimeToLive, connectionMaxIdleTime, useIdleConnectionReaper, protocol, channelOptions, (Option<SslProvider>)sslProvider, (Option<ProxyConfiguration>)proxyConfiguration, (Option<Http2Config>)http2Configuration);
            }
            throw new MatchError((Object)tuple14);
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(package$.class);
    }

    public Config<HttpOrHttps> httpOrHttps() {
        return httpOrHttps;
    }

    public Config<ProxyConfiguration> proxyConfiguration() {
        return proxyConfiguration;
    }

    public Config<Http2Config> http2Configuration() {
        return http2Configuration;
    }

    public <T, JT> Config<Option<NettyOptionValue<JT>>> channelOption(ChannelOption<JT> opt, Function1<T, JT> toJava, Config<T> desc) {
        return desc.nested(() -> this.channelOption$$anonfun$1(opt)).optional().map((Function1 & Serializable)_$1 -> _$1.map((Function1 & Serializable)value -> NettyOptionValue$.MODULE$.apply(opt, toJava.apply(value))));
    }

    public Config<Option<NettyOptionValue<Boolean>>> boolChannelOption(ChannelOption<Boolean> opt) {
        return this.channelOption(opt, (Function1 & Serializable)b -> this.boolChannelOption$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)b)), Config$.MODULE$.boolean());
    }

    public Config<Option<NettyOptionValue<Integer>>> intChannelOption(ChannelOption<Integer> opt) {
        return this.channelOption(opt, (Function1 & Serializable)i -> this.intChannelOption$$anonfun$1(BoxesRunTime.unboxToInt((Object)i)), Config$.MODULE$.int());
    }

    public Config<Option<NettyOptionValue<Integer>>> durationMsChannelOption(ChannelOption<Integer> opt) {
        return this.channelOption(opt, (Function1 & Serializable)d -> (int)d.toMillis(), Config$.MODULE$.duration());
    }

    public Config<NettyChannelOptions> nettyChannelOptions() {
        return nettyChannelOptions;
    }

    public Config<Protocol> protocol() {
        return protocol;
    }

    public Config<SslProvider> sslProvider() {
        return sslProvider;
    }

    public Config<NettyClientConfig> nettyClientConfig() {
        return nettyClientConfig;
    }

    private final String $init$$$anonfun$2() {
        return "scheme";
    }

    private final HttpOrHttps $init$$$anonfun$3() {
        return HttpOrHttps$Http$.MODULE$;
    }

    private final String $init$$$anonfun$4() {
        return "The proxy scheme";
    }

    private final String $init$$$anonfun$5$$anonfun$1() {
        return "Hostname of the proxy";
    }

    private final Config $init$$$anonfun$5() {
        return Config$.MODULE$.string("host").$qmark$qmark(this::$init$$$anonfun$5$$anonfun$1);
    }

    private final String $init$$$anonfun$6$$anonfun$1() {
        return "Port of the proxy";
    }

    private final Config $init$$$anonfun$6() {
        return Config$.MODULE$.int("port").$qmark$qmark(this::$init$$$anonfun$6$$anonfun$1);
    }

    private final Set $init$$$anonfun$7$$anonfun$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private final String $init$$$anonfun$7$$anonfun$2() {
        return "Hosts that should not be proxied";
    }

    private final Config $init$$$anonfun$7() {
        return Config$.MODULE$.setOf("nonProxyHosts", Config$.MODULE$.string()).withDefault(this::$init$$$anonfun$7$$anonfun$1).$qmark$qmark(this::$init$$$anonfun$7$$anonfun$2);
    }

    private final String $init$$$anonfun$9() {
        return "Max number of concurrent streams per connection";
    }

    private final String $init$$$anonfun$10$$anonfun$1() {
        return "Initial window size of a stream";
    }

    private final Config $init$$$anonfun$10() {
        return Config$.MODULE$.int("initialWindowSize").$qmark$qmark(this::$init$$$anonfun$10$$anonfun$1);
    }

    private final Duration $init$$$anonfun$11$$anonfun$1() {
        return DurationSyntax$.MODULE$.seconds$extension(zio.package$.MODULE$.durationInt(5));
    }

    private final String $init$$$anonfun$11$$anonfun$2() {
        return "The period that the Netty client will send PING frames to the remote endpoint";
    }

    private final Config $init$$$anonfun$11() {
        return Config$.MODULE$.duration("healthCheckPingPeriod").withDefault(this::$init$$$anonfun$11$$anonfun$1).$qmark$qmark(this::$init$$$anonfun$11$$anonfun$2);
    }

    private final String $anonfun$1() {
        return "Connect timeout";
    }

    private final String $anonfun$2$$anonfun$1() {
        return "Write spin count";
    }

    private final Config $anonfun$2() {
        return this.intChannelOption((ChannelOption<Integer>)ChannelOption.WRITE_SPIN_COUNT).$qmark$qmark(this::$anonfun$2$$anonfun$1);
    }

    private final String $anonfun$3$$anonfun$1() {
        return "Allow half closure";
    }

    private final Config $anonfun$3() {
        return this.boolChannelOption((ChannelOption<Boolean>)ChannelOption.ALLOW_HALF_CLOSURE).$qmark$qmark(this::$anonfun$3$$anonfun$1);
    }

    private final String $anonfun$4$$anonfun$1() {
        return "Auto read";
    }

    private final Config $anonfun$4() {
        return this.boolChannelOption((ChannelOption<Boolean>)ChannelOption.AUTO_READ).$qmark$qmark(this::$anonfun$4$$anonfun$1);
    }

    private final String $anonfun$5$$anonfun$1() {
        return "Auto close";
    }

    private final Config $anonfun$5() {
        return this.boolChannelOption((ChannelOption<Boolean>)ChannelOption.AUTO_CLOSE).$qmark$qmark(this::$anonfun$5$$anonfun$1);
    }

    private final String $anonfun$6$$anonfun$1() {
        return "Single event executor per group";
    }

    private final Config $anonfun$6() {
        return this.boolChannelOption((ChannelOption<Boolean>)ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP).$qmark$qmark(this::$anonfun$6$$anonfun$1);
    }

    private final Config $init$$$anonfun$13(Config channelOptions$1) {
        return channelOptions$1;
    }

    private final Object globalDefault$1(SdkHttpConfigurationOption key) {
        return SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS.get((AttributeMap.Key)key);
    }

    private final int $init$$$anonfun$17() {
        return Predef$.MODULE$.Integer2int((Integer)this.globalDefault$1(SdkHttpConfigurationOption.MAX_CONNECTIONS));
    }

    private final String $init$$$anonfun$18() {
        return "Maximum number of allowed concurrent requests";
    }

    private final int $init$$$anonfun$19$$anonfun$1() {
        return Predef$.MODULE$.Integer2int((Integer)this.globalDefault$1(SdkHttpConfigurationOption.MAX_PENDING_CONNECTION_ACQUIRES));
    }

    private final String $init$$$anonfun$19$$anonfun$2() {
        return "The maximum number of pending acquires allowed";
    }

    private final Config $init$$$anonfun$19() {
        return Config$.MODULE$.int("maxPendingConnectionAcquires").withDefault(this::$init$$$anonfun$19$$anonfun$1).$qmark$qmark(this::$init$$$anonfun$19$$anonfun$2);
    }

    private final Duration $init$$$anonfun$20$$anonfun$1() {
        return (Duration)this.globalDefault$1(SdkHttpConfigurationOption.READ_TIMEOUT);
    }

    private final String $init$$$anonfun$20$$anonfun$2() {
        return "The amount of time to wait for a read on a socket";
    }

    private final Config $init$$$anonfun$20() {
        return Config$.MODULE$.duration("readTimeout").withDefault(this::$init$$$anonfun$20$$anonfun$1).$qmark$qmark(this::$init$$$anonfun$20$$anonfun$2);
    }

    private final Duration $init$$$anonfun$21$$anonfun$1() {
        return (Duration)this.globalDefault$1(SdkHttpConfigurationOption.WRITE_TIMEOUT);
    }

    private final String $init$$$anonfun$21$$anonfun$2() {
        return "The amount of time to wait for a write on a socket";
    }

    private final Config $init$$$anonfun$21() {
        return Config$.MODULE$.duration("writeTimeout").withDefault(this::$init$$$anonfun$21$$anonfun$1).$qmark$qmark(this::$init$$$anonfun$21$$anonfun$2);
    }

    private final Duration $init$$$anonfun$22$$anonfun$1() {
        return (Duration)this.globalDefault$1(SdkHttpConfigurationOption.CONNECTION_TIMEOUT);
    }

    private final String $init$$$anonfun$22$$anonfun$2() {
        return "The amount of time to wait when initially establishing a connection before giving up";
    }

    private final Config $init$$$anonfun$22() {
        return Config$.MODULE$.duration("connectionTimeout").withDefault(this::$init$$$anonfun$22$$anonfun$1).$qmark$qmark(this::$init$$$anonfun$22$$anonfun$2);
    }

    private final Duration $init$$$anonfun$23$$anonfun$1() {
        return (Duration)this.globalDefault$1(SdkHttpConfigurationOption.CONNECTION_ACQUIRE_TIMEOUT);
    }

    private final String $init$$$anonfun$23$$anonfun$2() {
        return "The amount of time to wait when acquiring a connection from the pool before giving up";
    }

    private final Config $init$$$anonfun$23() {
        return Config$.MODULE$.duration("connectionAcquisitionTimeout").withDefault(this::$init$$$anonfun$23$$anonfun$1).$qmark$qmark(this::$init$$$anonfun$23$$anonfun$2);
    }

    private final Duration $init$$$anonfun$24$$anonfun$1() {
        return (Duration)this.globalDefault$1(SdkHttpConfigurationOption.CONNECTION_TIME_TO_LIVE);
    }

    private final String $init$$$anonfun$24$$anonfun$2() {
        return "The maximum amount of time that a connection should be allowed to remain open, regardless of usage frequency";
    }

    private final Config $init$$$anonfun$24() {
        return Config$.MODULE$.duration("connectionTimeToLive").withDefault(this::$init$$$anonfun$24$$anonfun$1).$qmark$qmark(this::$init$$$anonfun$24$$anonfun$2);
    }

    private final Duration $init$$$anonfun$25$$anonfun$1() {
        return DurationSyntax$.MODULE$.seconds$extension(zio.package$.MODULE$.durationInt(5));
    }

    private final String $init$$$anonfun$25$$anonfun$2() {
        return "Maximum amount of time that a connection should be allowed to remain open while idle";
    }

    private final Config $init$$$anonfun$25() {
        return Config$.MODULE$.duration("connectionMaxIdleTime").withDefault(this::$init$$$anonfun$25$$anonfun$1).$qmark$qmark(this::$init$$$anonfun$25$$anonfun$2);
    }

    private final boolean $init$$$anonfun$26$$anonfun$1() {
        return (Boolean)this.globalDefault$1(SdkHttpConfigurationOption.REAP_IDLE_CONNECTIONS);
    }

    private final String $init$$$anonfun$26$$anonfun$2() {
        return "If true, the idle connections in the pool should be closed";
    }

    private final Config $init$$$anonfun$26() {
        return Config$.MODULE$.boolean("useIdleConnectionReaper").withDefault(this::$init$$$anonfun$26$$anonfun$1).$qmark$qmark(this::$init$$$anonfun$26$$anonfun$2);
    }

    private final String $init$$$anonfun$27$$anonfun$1() {
        return "protocol";
    }

    private final Protocol $init$$$anonfun$27$$anonfun$2() {
        return Protocol.Dual$.MODULE$;
    }

    private final String $init$$$anonfun$27$$anonfun$3() {
        return "HTTP/1.1 or HTTP/2 or Dual";
    }

    private final Config $init$$$anonfun$27() {
        return this.protocol().nested(this::$init$$$anonfun$27$$anonfun$1).withDefault(this::$init$$$anonfun$27$$anonfun$2).$qmark$qmark(this::$init$$$anonfun$27$$anonfun$3);
    }

    private final String $init$$$anonfun$28$$anonfun$1() {
        return "channelOptions";
    }

    private final NettyChannelOptions $init$$$anonfun$28$$anonfun$2() {
        return NettyChannelOptions$.MODULE$.apply(scala.package$.MODULE$.Vector().empty());
    }

    private final String $init$$$anonfun$28$$anonfun$3() {
        return "Custom Netty channel options";
    }

    private final Config $init$$$anonfun$28() {
        return this.nettyChannelOptions().nested(this::$init$$$anonfun$28$$anonfun$1).withDefault(this::$init$$$anonfun$28$$anonfun$2).$qmark$qmark(this::$init$$$anonfun$28$$anonfun$3);
    }

    private final String $init$$$anonfun$29$$anonfun$1() {
        return "sslProvider";
    }

    private final String $init$$$anonfun$29$$anonfun$2() {
        return "The SSL provider to be used";
    }

    private final Config $init$$$anonfun$29() {
        return this.sslProvider().nested(this::$init$$$anonfun$29$$anonfun$1).optional().$qmark$qmark(this::$init$$$anonfun$29$$anonfun$2);
    }

    private final String $init$$$anonfun$30$$anonfun$1() {
        return "proxy";
    }

    private final String $init$$$anonfun$30$$anonfun$2() {
        return "Proxy configuration";
    }

    private final Config $init$$$anonfun$30() {
        return this.proxyConfiguration().nested(this::$init$$$anonfun$30$$anonfun$1).optional().$qmark$qmark(this::$init$$$anonfun$30$$anonfun$2);
    }

    private final String $init$$$anonfun$31$$anonfun$1() {
        return "http2";
    }

    private final String $init$$$anonfun$31$$anonfun$2() {
        return "HTTP/2 specific options";
    }

    private final Config $init$$$anonfun$31() {
        return this.http2Configuration().nested(this::$init$$$anonfun$31$$anonfun$1).optional().$qmark$qmark(this::$init$$$anonfun$31$$anonfun$2);
    }

    private final String channelOption$$anonfun$1(ChannelOption opt$1) {
        return opt$1.name();
    }

    private final /* synthetic */ Boolean boolChannelOption$$anonfun$1(boolean b) {
        return b;
    }

    private final /* synthetic */ Integer intChannelOption$$anonfun$1(int i) {
        return i;
    }
}

