package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{
  ResourceName,
  ResourceArn,
  UpdateToken
}
import scala.jdk.CollectionConverters._
final case class AssociateSubnetsRequest(
    updateToken: Option[UpdateToken] = None,
    firewallArn: Option[ResourceArn] = None,
    firewallName: Option[ResourceName] = None,
    subnetMappings: Iterable[zio.aws.networkfirewall.model.SubnetMapping]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsRequest = {
    import AssociateSubnetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsRequest
      .builder()
      .optionallyWith(
        updateToken.map(value => UpdateToken.unwrap(value): java.lang.String)
      )(_.updateToken)
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .subnetMappings(subnetMappings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.AssociateSubnetsRequest.ReadOnly =
    zio.aws.networkfirewall.model.AssociateSubnetsRequest.wrap(buildAwsValue())
}
object AssociateSubnetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.AssociateSubnetsRequest =
      zio.aws.networkfirewall.model.AssociateSubnetsRequest(
        updateToken.map(value => value),
        firewallArn.map(value => value),
        firewallName.map(value => value),
        subnetMappings.map { item =>
          item.asEditable
        }
      )
    def updateToken: Option[UpdateToken]
    def firewallArn: Option[ResourceArn]
    def firewallName: Option[ResourceName]
    def subnetMappings
        : List[zio.aws.networkfirewall.model.SubnetMapping.ReadOnly]
    def getUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("updateToken", updateToken)
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getSubnetMappings: ZIO[Any, Nothing, List[
      zio.aws.networkfirewall.model.SubnetMapping.ReadOnly
    ]] = ZIO.succeed(subnetMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsRequest
  ) extends zio.aws.networkfirewall.model.AssociateSubnetsRequest.ReadOnly {
    override val updateToken: Option[UpdateToken] = scala
      .Option(impl.updateToken())
      .map(value => zio.aws.networkfirewall.model.primitives.UpdateToken(value))
    override val firewallArn: Option[ResourceArn] = scala
      .Option(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallName: Option[ResourceName] = scala
      .Option(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val subnetMappings
        : List[zio.aws.networkfirewall.model.SubnetMapping.ReadOnly] = impl
      .subnetMappings()
      .asScala
      .map { item =>
        zio.aws.networkfirewall.model.SubnetMapping.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsRequest
  ): zio.aws.networkfirewall.model.AssociateSubnetsRequest.ReadOnly =
    new Wrapper(impl)
}
