package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{
  UpdateToken,
  ResourceName,
  ResourceArn
}
import scala.jdk.CollectionConverters._
final case class AssociateSubnetsResponse(
    firewallArn: Option[ResourceArn] = None,
    firewallName: Option[ResourceName] = None,
    subnetMappings: Option[
      Iterable[zio.aws.networkfirewall.model.SubnetMapping]
    ] = None,
    updateToken: Option[UpdateToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsResponse = {
    import AssociateSubnetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsResponse
      .builder()
      .optionallyWith(
        firewallArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.firewallName)
      .optionallyWith(
        subnetMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnetMappings)
      .optionallyWith(
        updateToken.map(value => UpdateToken.unwrap(value): java.lang.String)
      )(_.updateToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.AssociateSubnetsResponse.ReadOnly =
    zio.aws.networkfirewall.model.AssociateSubnetsResponse.wrap(buildAwsValue())
}
object AssociateSubnetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.AssociateSubnetsResponse =
      zio.aws.networkfirewall.model.AssociateSubnetsResponse(
        firewallArn.map(value => value),
        firewallName.map(value => value),
        subnetMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        updateToken.map(value => value)
      )
    def firewallArn: Option[ResourceArn]
    def firewallName: Option[ResourceName]
    def subnetMappings
        : Option[List[zio.aws.networkfirewall.model.SubnetMapping.ReadOnly]]
    def updateToken: Option[UpdateToken]
    def getFirewallArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getSubnetMappings: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.SubnetMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("subnetMappings", subnetMappings)
    def getUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("updateToken", updateToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsResponse
  ) extends zio.aws.networkfirewall.model.AssociateSubnetsResponse.ReadOnly {
    override val firewallArn: Option[ResourceArn] = scala
      .Option(impl.firewallArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
    override val firewallName: Option[ResourceName] = scala
      .Option(impl.firewallName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val subnetMappings
        : Option[List[zio.aws.networkfirewall.model.SubnetMapping.ReadOnly]] =
      scala
        .Option(impl.subnetMappings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkfirewall.model.SubnetMapping.wrap(item)
          }.toList
        )
    override val updateToken: Option[UpdateToken] = scala
      .Option(impl.updateToken())
      .map(value => zio.aws.networkfirewall.model.primitives.UpdateToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsResponse
  ): zio.aws.networkfirewall.model.AssociateSubnetsResponse.ReadOnly =
    new Wrapper(impl)
}
