package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFirewallResponse(
    firewall: Option[zio.aws.networkfirewall.model.Firewall] = None,
    firewallStatus: Option[zio.aws.networkfirewall.model.FirewallStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.CreateFirewallResponse = {
    import CreateFirewallResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.CreateFirewallResponse
      .builder()
      .optionallyWith(firewall.map(value => value.buildAwsValue()))(_.firewall)
      .optionallyWith(firewallStatus.map(value => value.buildAwsValue()))(
        _.firewallStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.CreateFirewallResponse.ReadOnly =
    zio.aws.networkfirewall.model.CreateFirewallResponse.wrap(buildAwsValue())
}
object CreateFirewallResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.CreateFirewallResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.CreateFirewallResponse =
      zio.aws.networkfirewall.model.CreateFirewallResponse(
        firewall.map(value => value.asEditable),
        firewallStatus.map(value => value.asEditable)
      )
    def firewall: Option[zio.aws.networkfirewall.model.Firewall.ReadOnly]
    def firewallStatus
        : Option[zio.aws.networkfirewall.model.FirewallStatus.ReadOnly]
    def getFirewall
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.Firewall.ReadOnly] =
      AwsError.unwrapOptionField("firewall", firewall)
    def getFirewallStatus: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.FirewallStatus.ReadOnly
    ] = AwsError.unwrapOptionField("firewallStatus", firewallStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.CreateFirewallResponse
  ) extends zio.aws.networkfirewall.model.CreateFirewallResponse.ReadOnly {
    override val firewall
        : Option[zio.aws.networkfirewall.model.Firewall.ReadOnly] = scala
      .Option(impl.firewall())
      .map(value => zio.aws.networkfirewall.model.Firewall.wrap(value))
    override val firewallStatus
        : Option[zio.aws.networkfirewall.model.FirewallStatus.ReadOnly] = scala
      .Option(impl.firewallStatus())
      .map(value => zio.aws.networkfirewall.model.FirewallStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.CreateFirewallResponse
  ): zio.aws.networkfirewall.model.CreateFirewallResponse.ReadOnly =
    new Wrapper(impl)
}
