package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{ResourceArn, ResourceName}
import scala.jdk.CollectionConverters._
final case class DeleteFirewallPolicyRequest(
    firewallPolicyName: Option[ResourceName] = None,
    firewallPolicyArn: Option[ResourceArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyRequest = {
    import DeleteFirewallPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyRequest
      .builder()
      .optionallyWith(
        firewallPolicyName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.firewallPolicyName)
      .optionallyWith(
        firewallPolicyArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.firewallPolicyArn)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DeleteFirewallPolicyRequest.ReadOnly =
    zio.aws.networkfirewall.model.DeleteFirewallPolicyRequest
      .wrap(buildAwsValue())
}
object DeleteFirewallPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.DeleteFirewallPolicyRequest =
      zio.aws.networkfirewall.model.DeleteFirewallPolicyRequest(
        firewallPolicyName.map(value => value),
        firewallPolicyArn.map(value => value)
      )
    def firewallPolicyName: Option[ResourceName]
    def firewallPolicyArn: Option[ResourceArn]
    def getFirewallPolicyName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("firewallPolicyName", firewallPolicyName)
    def getFirewallPolicyArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("firewallPolicyArn", firewallPolicyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyRequest
  ) extends zio.aws.networkfirewall.model.DeleteFirewallPolicyRequest.ReadOnly {
    override val firewallPolicyName: Option[ResourceName] = scala
      .Option(impl.firewallPolicyName())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.ResourceName(value)
      )
    override val firewallPolicyArn: Option[ResourceArn] = scala
      .Option(impl.firewallPolicyArn())
      .map(value => zio.aws.networkfirewall.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyRequest
  ): zio.aws.networkfirewall.model.DeleteFirewallPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
