package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class DescribeResourcePolicyRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyRequest = {
    import DescribeResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.DescribeResourcePolicyRequest.ReadOnly =
    zio.aws.networkfirewall.model.DescribeResourcePolicyRequest
      .wrap(buildAwsValue())
}
object DescribeResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkfirewall.model.DescribeResourcePolicyRequest =
      zio.aws.networkfirewall.model.DescribeResourcePolicyRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyRequest
  ) extends zio.aws.networkfirewall.model.DescribeResourcePolicyRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.networkfirewall.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyRequest
  ): zio.aws.networkfirewall.model.DescribeResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
