package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.DimensionValue
import scala.jdk.CollectionConverters._
final case class Dimension(value: DimensionValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.Dimension = {
    import Dimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.Dimension
      .builder()
      .value(DimensionValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.Dimension.ReadOnly =
    zio.aws.networkfirewall.model.Dimension.wrap(buildAwsValue())
}
object Dimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.Dimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.Dimension =
      zio.aws.networkfirewall.model.Dimension(value)
    def value: DimensionValue
    def getValue: ZIO[Any, Nothing, DimensionValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.Dimension
  ) extends zio.aws.networkfirewall.model.Dimension.ReadOnly {
    override val value: DimensionValue =
      zio.aws.networkfirewall.model.primitives.DimensionValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.Dimension
  ): zio.aws.networkfirewall.model.Dimension.ReadOnly = new Wrapper(impl)
}
