package zio.aws.networkfirewall.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{
  RuleCapacity,
  Description,
  ResourceArn,
  NumberOfAssociations,
  ResourceId,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class FirewallPolicyResponse(
    firewallPolicyName: ResourceName,
    firewallPolicyArn: ResourceArn,
    firewallPolicyId: ResourceId,
    description: Option[Description] = None,
    firewallPolicyStatus: Option[zio.aws.networkfirewall.model.ResourceStatus] =
      None,
    tags: Option[Iterable[zio.aws.networkfirewall.model.Tag]] = None,
    consumedStatelessRuleCapacity: Option[RuleCapacity] = None,
    consumedStatefulRuleCapacity: Option[RuleCapacity] = None,
    numberOfAssociations: Option[NumberOfAssociations] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.FirewallPolicyResponse = {
    import FirewallPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.FirewallPolicyResponse
      .builder()
      .firewallPolicyName(
        ResourceName.unwrap(firewallPolicyName): java.lang.String
      )
      .firewallPolicyArn(
        ResourceArn.unwrap(firewallPolicyArn): java.lang.String
      )
      .firewallPolicyId(ResourceId.unwrap(firewallPolicyId): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(firewallPolicyStatus.map(value => value.unwrap))(
        _.firewallPolicyStatus
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        consumedStatelessRuleCapacity.map(value =>
          RuleCapacity.unwrap(value): Integer
        )
      )(_.consumedStatelessRuleCapacity)
      .optionallyWith(
        consumedStatefulRuleCapacity.map(value =>
          RuleCapacity.unwrap(value): Integer
        )
      )(_.consumedStatefulRuleCapacity)
      .optionallyWith(
        numberOfAssociations.map(value =>
          NumberOfAssociations.unwrap(value): Integer
        )
      )(_.numberOfAssociations)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.FirewallPolicyResponse.ReadOnly =
    zio.aws.networkfirewall.model.FirewallPolicyResponse.wrap(buildAwsValue())
}
object FirewallPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.FirewallPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.FirewallPolicyResponse =
      zio.aws.networkfirewall.model.FirewallPolicyResponse(
        firewallPolicyName,
        firewallPolicyArn,
        firewallPolicyId,
        description.map(value => value),
        firewallPolicyStatus.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        consumedStatelessRuleCapacity.map(value => value),
        consumedStatefulRuleCapacity.map(value => value),
        numberOfAssociations.map(value => value)
      )
    def firewallPolicyName: ResourceName
    def firewallPolicyArn: ResourceArn
    def firewallPolicyId: ResourceId
    def description: Option[Description]
    def firewallPolicyStatus
        : Option[zio.aws.networkfirewall.model.ResourceStatus]
    def tags: Option[List[zio.aws.networkfirewall.model.Tag.ReadOnly]]
    def consumedStatelessRuleCapacity: Option[RuleCapacity]
    def consumedStatefulRuleCapacity: Option[RuleCapacity]
    def numberOfAssociations: Option[NumberOfAssociations]
    def getFirewallPolicyName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(firewallPolicyName)
    def getFirewallPolicyArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(firewallPolicyArn)
    def getFirewallPolicyId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallPolicyId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getFirewallPolicyStatus
        : ZIO[Any, AwsError, zio.aws.networkfirewall.model.ResourceStatus] =
      AwsError.unwrapOptionField("firewallPolicyStatus", firewallPolicyStatus)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkfirewall.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getConsumedStatelessRuleCapacity: ZIO[Any, AwsError, RuleCapacity] =
      AwsError.unwrapOptionField(
        "consumedStatelessRuleCapacity",
        consumedStatelessRuleCapacity
      )
    def getConsumedStatefulRuleCapacity: ZIO[Any, AwsError, RuleCapacity] =
      AwsError.unwrapOptionField(
        "consumedStatefulRuleCapacity",
        consumedStatefulRuleCapacity
      )
    def getNumberOfAssociations: ZIO[Any, AwsError, NumberOfAssociations] =
      AwsError.unwrapOptionField("numberOfAssociations", numberOfAssociations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.FirewallPolicyResponse
  ) extends zio.aws.networkfirewall.model.FirewallPolicyResponse.ReadOnly {
    override val firewallPolicyName: ResourceName =
      zio.aws.networkfirewall.model.primitives
        .ResourceName(impl.firewallPolicyName())
    override val firewallPolicyArn: ResourceArn =
      zio.aws.networkfirewall.model.primitives
        .ResourceArn(impl.firewallPolicyArn())
    override val firewallPolicyId: ResourceId =
      zio.aws.networkfirewall.model.primitives
        .ResourceId(impl.firewallPolicyId())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.networkfirewall.model.primitives.Description(value))
    override val firewallPolicyStatus
        : Option[zio.aws.networkfirewall.model.ResourceStatus] = scala
      .Option(impl.firewallPolicyStatus())
      .map(value => zio.aws.networkfirewall.model.ResourceStatus.wrap(value))
    override val tags
        : Option[List[zio.aws.networkfirewall.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.Tag.wrap(item)
        }.toList
      )
    override val consumedStatelessRuleCapacity: Option[RuleCapacity] = scala
      .Option(impl.consumedStatelessRuleCapacity())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.RuleCapacity(value)
      )
    override val consumedStatefulRuleCapacity: Option[RuleCapacity] = scala
      .Option(impl.consumedStatefulRuleCapacity())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.RuleCapacity(value)
      )
    override val numberOfAssociations: Option[NumberOfAssociations] = scala
      .Option(impl.numberOfAssociations())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.NumberOfAssociations(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.FirewallPolicyResponse
  ): zio.aws.networkfirewall.model.FirewallPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
