package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListFirewallPoliciesResponse(
    nextToken: Option[PaginationToken] = None,
    firewallPolicies: Option[
      Iterable[zio.aws.networkfirewall.model.FirewallPolicyMetadata]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse = {
    import ListFirewallPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        firewallPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.firewallPolicies)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.ListFirewallPoliciesResponse.ReadOnly =
    zio.aws.networkfirewall.model.ListFirewallPoliciesResponse
      .wrap(buildAwsValue())
}
object ListFirewallPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.ListFirewallPoliciesResponse =
      zio.aws.networkfirewall.model.ListFirewallPoliciesResponse(
        nextToken.map(value => value),
        firewallPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[PaginationToken]
    def firewallPolicies: Option[
      List[zio.aws.networkfirewall.model.FirewallPolicyMetadata.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFirewallPolicies: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.FirewallPolicyMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("firewallPolicies", firewallPolicies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse
  ) extends zio.aws.networkfirewall.model.ListFirewallPoliciesResponse.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.PaginationToken(value)
      )
    override val firewallPolicies: Option[
      List[zio.aws.networkfirewall.model.FirewallPolicyMetadata.ReadOnly]
    ] = scala
      .Option(impl.firewallPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.FirewallPolicyMetadata.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse
  ): zio.aws.networkfirewall.model.ListFirewallPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
