package zio.aws.networkfirewall.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{
  PaginationMaxResults,
  PaginationToken
}
import scala.jdk.CollectionConverters._
final case class ListRuleGroupsRequest(
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[PaginationMaxResults] = None,
    scope: Option[zio.aws.networkfirewall.model.ResourceManagedStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest = {
    import ListRuleGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => PaginationMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(scope.map(value => value.unwrap))(_.scope)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.ListRuleGroupsRequest.ReadOnly =
    zio.aws.networkfirewall.model.ListRuleGroupsRequest.wrap(buildAwsValue())
}
object ListRuleGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.ListRuleGroupsRequest =
      zio.aws.networkfirewall.model.ListRuleGroupsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        scope.map(value => value)
      )
    def nextToken: Option[PaginationToken]
    def maxResults: Option[PaginationMaxResults]
    def scope: Option[zio.aws.networkfirewall.model.ResourceManagedStatus]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PaginationMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getScope: ZIO[
      Any,
      AwsError,
      zio.aws.networkfirewall.model.ResourceManagedStatus
    ] = AwsError.unwrapOptionField("scope", scope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest
  ) extends zio.aws.networkfirewall.model.ListRuleGroupsRequest.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.PaginationToken(value)
      )
    override val maxResults: Option[PaginationMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.PaginationMaxResults(value)
      )
    override val scope
        : Option[zio.aws.networkfirewall.model.ResourceManagedStatus] = scala
      .Option(impl.scope())
      .map(value =>
        zio.aws.networkfirewall.model.ResourceManagedStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest
  ): zio.aws.networkfirewall.model.ListRuleGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
