package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListRuleGroupsResponse(
    nextToken: Option[PaginationToken] = None,
    ruleGroups: Option[
      Iterable[zio.aws.networkfirewall.model.RuleGroupMetadata]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse = {
    import ListRuleGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        ruleGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ruleGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.ListRuleGroupsResponse.ReadOnly =
    zio.aws.networkfirewall.model.ListRuleGroupsResponse.wrap(buildAwsValue())
}
object ListRuleGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.ListRuleGroupsResponse =
      zio.aws.networkfirewall.model.ListRuleGroupsResponse(
        nextToken.map(value => value),
        ruleGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[PaginationToken]
    def ruleGroups
        : Option[List[zio.aws.networkfirewall.model.RuleGroupMetadata.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRuleGroups: ZIO[Any, AwsError, List[
      zio.aws.networkfirewall.model.RuleGroupMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("ruleGroups", ruleGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse
  ) extends zio.aws.networkfirewall.model.ListRuleGroupsResponse.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.PaginationToken(value)
      )
    override val ruleGroups: Option[
      List[zio.aws.networkfirewall.model.RuleGroupMetadata.ReadOnly]
    ] = scala
      .Option(impl.ruleGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkfirewall.model.RuleGroupMetadata.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse
  ): zio.aws.networkfirewall.model.ListRuleGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
