package zio.aws.networkfirewall.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.{
  ResourceArn,
  TagsPaginationMaxResults,
  PaginationToken
}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[TagsPaginationMaxResults] = None,
    resourceArn: ResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => TagsPaginationMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.networkfirewall.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.ListTagsForResourceRequest =
      zio.aws.networkfirewall.model.ListTagsForResourceRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        resourceArn
      )
    def nextToken: Option[PaginationToken]
    def maxResults: Option[TagsPaginationMaxResults]
    def resourceArn: ResourceArn
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, TagsPaginationMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest
  ) extends zio.aws.networkfirewall.model.ListTagsForResourceRequest.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.PaginationToken(value)
      )
    override val maxResults: Option[TagsPaginationMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.networkfirewall.model.primitives.TagsPaginationMaxResults(value)
      )
    override val resourceArn: ResourceArn =
      zio.aws.networkfirewall.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest
  ): zio.aws.networkfirewall.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
