package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters._
sealed trait LogDestinationType {
  def unwrap
      : software.amazon.awssdk.services.networkfirewall.model.LogDestinationType
}
object LogDestinationType {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.LogDestinationType
  ): zio.aws.networkfirewall.model.LogDestinationType = value match {
    case software.amazon.awssdk.services.networkfirewall.model.LogDestinationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.LogDestinationType.S3 =>
      val r = S3
      r
    case software.amazon.awssdk.services.networkfirewall.model.LogDestinationType.CLOUD_WATCH_LOGS =>
      val r = CloudWatchLogs
      r
    case software.amazon.awssdk.services.networkfirewall.model.LogDestinationType.KINESIS_DATA_FIREHOSE =>
      val r = KinesisDataFirehose
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.LogDestinationType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.LogDestinationType =
      software.amazon.awssdk.services.networkfirewall.model.LogDestinationType.UNKNOWN_TO_SDK_VERSION
  }
  case object S3 extends zio.aws.networkfirewall.model.LogDestinationType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.LogDestinationType =
      software.amazon.awssdk.services.networkfirewall.model.LogDestinationType.S3
  }
  case object CloudWatchLogs
      extends zio.aws.networkfirewall.model.LogDestinationType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.LogDestinationType =
      software.amazon.awssdk.services.networkfirewall.model.LogDestinationType.CLOUD_WATCH_LOGS
  }
  case object KinesisDataFirehose
      extends zio.aws.networkfirewall.model.LogDestinationType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.LogDestinationType =
      software.amazon.awssdk.services.networkfirewall.model.LogDestinationType.KINESIS_DATA_FIREHOSE
  }
}
