package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.{PolicyString, ResourceArn}
import scala.jdk.CollectionConverters._
final case class PutResourcePolicyRequest(
    resourceArn: ResourceArn,
    policy: PolicyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyRequest = {
    import PutResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .policy(PolicyString.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.networkfirewall.model.PutResourcePolicyRequest.ReadOnly =
    zio.aws.networkfirewall.model.PutResourcePolicyRequest.wrap(buildAwsValue())
}
object PutResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.PutResourcePolicyRequest =
      zio.aws.networkfirewall.model
        .PutResourcePolicyRequest(resourceArn, policy)
    def resourceArn: ResourceArn
    def policy: PolicyString
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getPolicy: ZIO[Any, Nothing, PolicyString] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyRequest
  ) extends zio.aws.networkfirewall.model.PutResourcePolicyRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.networkfirewall.model.primitives.ResourceArn(impl.resourceArn())
    override val policy: PolicyString =
      zio.aws.networkfirewall.model.primitives.PolicyString(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyRequest
  ): zio.aws.networkfirewall.model.PutResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
