package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.networkfirewall.model.primitives.CollectionMember_String
import scala.jdk.CollectionConverters._
final case class RuleDefinition(
    matchAttributes: zio.aws.networkfirewall.model.MatchAttributes,
    actions: Iterable[CollectionMember_String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.RuleDefinition = {
    import RuleDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.RuleDefinition
      .builder()
      .matchAttributes(matchAttributes.buildAwsValue())
      .actions(actions.map { item =>
        CollectionMember_String.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.RuleDefinition.ReadOnly =
    zio.aws.networkfirewall.model.RuleDefinition.wrap(buildAwsValue())
}
object RuleDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.RuleDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.RuleDefinition =
      zio.aws.networkfirewall.model
        .RuleDefinition(matchAttributes.asEditable, actions)
    def matchAttributes: zio.aws.networkfirewall.model.MatchAttributes.ReadOnly
    def actions: List[CollectionMember_String]
    def getMatchAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.networkfirewall.model.MatchAttributes.ReadOnly
    ] = ZIO.succeed(matchAttributes)
    def getActions: ZIO[Any, Nothing, List[CollectionMember_String]] =
      ZIO.succeed(actions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.RuleDefinition
  ) extends zio.aws.networkfirewall.model.RuleDefinition.ReadOnly {
    override val matchAttributes
        : zio.aws.networkfirewall.model.MatchAttributes.ReadOnly =
      zio.aws.networkfirewall.model.MatchAttributes.wrap(impl.matchAttributes())
    override val actions: List[CollectionMember_String] = impl
      .actions()
      .asScala
      .map { item =>
        zio.aws.networkfirewall.model.primitives.CollectionMember_String(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.RuleDefinition
  ): zio.aws.networkfirewall.model.RuleDefinition.ReadOnly = new Wrapper(impl)
}
